/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public abstract class CompatMath {
    public static Quaternionf getQuat(Vector3f axis, float rotationAngle, boolean degrees) {
        if (degrees) {
            rotationAngle *= (float)Math.PI / 180;
        }
        float f = CompatMath.sin(rotationAngle / 2.0f);
        return new Quaternionf(axis.x() * f, axis.y() * f, axis.z() * f, CompatMath.cos(rotationAngle / 2.0f));
    }

    public static Quaternionf hamiltonProduct(Quaternionf a, Quaternionf b) {
        float f = a.x();
        float g = a.y();
        float h = a.z();
        float i = a.w();
        float j = b.x();
        float k = b.y();
        float l = b.z();
        float m = b.w();
        float x = i * j + f * m + g * l - h * k;
        float y = i * k - f * l + g * m + h * j;
        float z = i * l + f * k - g * j + h * m;
        float w = i * m - f * j - g * k - h * l;
        return new Quaternionf(x, y, z, w);
    }

    public static BlockPos fastBlockPos(Vec3 p) {
        return BlockPos.m_274561_((double)p.f_82479_, (double)p.f_82480_, (double)p.f_82481_);
    }

    private static float sin(float value) {
        return (float)Math.sin(value);
    }

    private static float cos(float value) {
        return (float)Math.cos(value);
    }
}

