/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.Unpooled;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.entity.CommonGravityComponent;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.GravityVerifierRegistry;
import net.arna.jcraft.common.gravity.util.NetworkUtil;
import net.arna.jcraft.common.gravity.util.packet.DefaultGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.GravityPacket;
import net.arna.jcraft.common.gravity.util.packet.InvertGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.OverwriteGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.UpdateGravityPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class GravityChannel<P extends GravityPacket> {
    public static GravityChannel<OverwriteGravityPacket> OVERWRITE_GRAVITY = new GravityChannel<OverwriteGravityPacket>(OverwriteGravityPacket::new, JCraft.id("g_overwrite_gravity_list"));
    public static GravityChannel<UpdateGravityPacket> UPDATE_GRAVITY = new GravityChannel<UpdateGravityPacket>(UpdateGravityPacket::new, JCraft.id("g_update_gravity_list"));
    public static GravityChannel<DefaultGravityPacket> DEFAULT_GRAVITY = new GravityChannel<DefaultGravityPacket>(DefaultGravityPacket::new, JCraft.id("g_default_gravity"));
    public static GravityChannel<InvertGravityPacket> INVERT_GRAVITY = new GravityChannel<InvertGravityPacket>(InvertGravityPacket::new, JCraft.id("g_inverted"));
    private final Factory<P> packetFactory;
    private final ResourceLocation channel;
    private final GravityVerifierRegistry<P> gravityVerifierRegistry;

    GravityChannel(Factory<P> _packetFactory, ResourceLocation _channel) {
        this.packetFactory = _packetFactory;
        this.channel = _channel;
        this.gravityVerifierRegistry = new GravityVerifierRegistry();
    }

    public void sendToClient(Entity entity, P packet, NetworkUtil.PacketMode mode) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(entity.m_19879_());
        ((GravityPacket)packet).write(buf);
        NetworkUtil.sendToTracking(entity, this.channel, buf, mode);
    }

    public void receiveFromClient(FriendlyByteBuf buf, MinecraftServer server, ServerPlayer player) {
        P packet = this.packetFactory.read(buf);
        ResourceLocation verifier = buf.m_130281_();
        FriendlyByteBuf verifierInfoBuf = new FriendlyByteBuf(Unpooled.buffer());
        verifierInfoBuf.writeBytes(buf.m_130052_());
        server.execute(() -> NetworkUtil.getGravityComponent((Entity)player).ifPresent(gc -> {
            GravityVerifierRegistry.VerifierFunction<P> v = this.gravityVerifierRegistry.get(verifier);
            if (v != null && v.check(player, verifierInfoBuf, packet)) {
                packet.run((CommonGravityComponent)gc);
                this.sendToClient((Entity)player, packet, NetworkUtil.PacketMode.EVERYONE_BUT_SELF);
            } else {
                GravityChannel.sendFullStatePacket((Entity)player, NetworkUtil.PacketMode.ONLY_SELF, packet.getRotationParameters(), false);
            }
        }));
    }

    public static void sendFullStatePacket(Entity entity, NetworkUtil.PacketMode mode, RotationParameters rp, boolean initialGravity) {
        NetworkUtil.getGravityComponent(entity).ifPresent(gc -> {
            OVERWRITE_GRAVITY.sendToClient(entity, new OverwriteGravityPacket(gc.getGravity(), initialGravity), mode);
            DEFAULT_GRAVITY.sendToClient(entity, new DefaultGravityPacket(gc.getDefaultGravityDirection(), rp, initialGravity), mode);
            INVERT_GRAVITY.sendToClient(entity, new InvertGravityPacket(gc.getInvertGravity(), rp, initialGravity), mode);
        });
    }

    public GravityVerifierRegistry<P> getVerifierRegistry() {
        return this.gravityVerifierRegistry;
    }

    public void registerServerReceiver() {
        if (Platform.getEnvironment() == Env.SERVER) {
            return;
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)this.channel, (buf, context) -> this.receiveFromClient(buf, context.getPlayer().m_20194_(), (ServerPlayer)context.getPlayer()));
    }

    public static void registerReceivers() {
        DEFAULT_GRAVITY.registerServerReceiver();
        UPDATE_GRAVITY.registerServerReceiver();
        OVERWRITE_GRAVITY.registerServerReceiver();
        INVERT_GRAVITY.registerServerReceiver();
    }

    @FunctionalInterface
    static interface Factory<T extends GravityPacket> {
        public T read(FriendlyByteBuf var1);
    }
}

