/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util;

import java.util.HashMap;
import java.util.Map;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.common.gravity.util.packet.GravityPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class GravityVerifierRegistry<T extends GravityPacket> {
    private final Map<ResourceLocation, VerifierFunction<T>> map = new HashMap<ResourceLocation, VerifierFunction<T>>();

    public void register(ResourceLocation id, VerifierFunction<T> func) {
        if (this.map.containsKey(id)) {
            JCraft.LOGGER.error((Object)new Exception("Verifier function already set for identifier " + String.valueOf(id)));
        }
        this.map.put(id, func);
    }

    @Nullable
    public VerifierFunction<T> get(ResourceLocation id) {
        return this.map.get(id);
    }

    @FunctionalInterface
    public static interface VerifierFunction<V extends GravityPacket> {
        public boolean check(ServerPlayer var1, FriendlyByteBuf var2, V var3);
    }
}

