/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.arna.jcraft.api.component.entity.CommonGravityComponent;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class NetworkUtil {
    public static Optional<CommonGravityComponent> getGravityComponent(Entity entity) {
        CommonGravityComponent gc = GravityChangerAPI.getGravityComponent(entity);
        if (gc == null) {
            return Optional.empty();
        }
        return Optional.of(gc);
    }

    public static void sendToTracking(@NonNull Entity entity, ResourceLocation channel, FriendlyByteBuf buf, PacketMode mode) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (mode != PacketMode.EVERYONE_BUT_SELF && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)channel, (FriendlyByteBuf)new FriendlyByteBuf(buf.copy()));
        }
        if (mode != PacketMode.ONLY_SELF) {
            Set recipients = JUtils.tracking(entity).stream().filter(serverPlayer -> serverPlayer != entity).collect(Collectors.toUnmodifiableSet());
            NetworkManager.sendToPlayers(recipients, (ResourceLocation)channel, (FriendlyByteBuf)buf);
        }
    }

    public static void writeDirection(FriendlyByteBuf buf, Direction direction) {
        buf.writeByte(direction == null ? -1 : direction.m_122411_());
    }

    public static void writeRotationParameters(FriendlyByteBuf buf, RotationParameters rotationParameters) {
        buf.writeBoolean(rotationParameters.rotateVelocity());
        buf.writeBoolean(rotationParameters.rotateView());
        buf.writeBoolean(rotationParameters.alternateCenter());
        buf.writeInt(rotationParameters.rotationTime());
    }

    public static void writeGravity(FriendlyByteBuf buf, Gravity gravity) {
        NetworkUtil.writeDirection(buf, gravity.direction());
        buf.writeInt(gravity.priority());
        buf.writeInt(gravity.duration());
        buf.m_130070_(gravity.source());
        NetworkUtil.writeRotationParameters(buf, gravity.rotationParameters());
    }

    public static RotationParameters readRotationParameters(FriendlyByteBuf buf) {
        return new RotationParameters(buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readInt());
    }

    public static Direction readDirection(FriendlyByteBuf buf) {
        byte rawDirection = buf.readByte();
        return 0 <= rawDirection && rawDirection < Direction.values().length ? Direction.m_122376_((int)rawDirection) : null;
    }

    public static Gravity readGravity(FriendlyByteBuf buf) {
        return new Gravity(NetworkUtil.readDirection(buf), buf.readInt(), buf.readInt(), buf.m_130277_(), NetworkUtil.readRotationParameters(buf));
    }

    public static enum PacketMode {
        EVERYONE,
        EVERYONE_BUT_SELF,
        ONLY_SELF;

    }
}

