/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class QuaternionUtil {
    public static float magnitude(Quaternionf quaternion) {
        return Mth.m_14116_((float)(quaternion.w() * quaternion.w() + quaternion.x() * quaternion.x() + quaternion.y() * quaternion.y() + quaternion.z() * quaternion.z()));
    }

    public static float magnitudeSq(Quaternionf quaternion) {
        return quaternion.w() * quaternion.w() + quaternion.x() * quaternion.x() + quaternion.y() * quaternion.y() + quaternion.z() * quaternion.z();
    }

    public static Quaternionf quaternionf(Vector3f axis, float rotationAngle, boolean degrees) {
        if (degrees) {
            rotationAngle *= (float)Math.PI / 180;
        }
        float f = org.joml.Math.sin((float)(rotationAngle / 2.0f));
        float x = axis.x() * f;
        float y = axis.y() * f;
        float z = axis.z() * f;
        double w = Math.cos(rotationAngle / 2.0f);
        return new Quaternionf((double)x, (double)y, (double)z, w);
    }

    public static Quaternionf hamiltonProduct(Quaternionf p, Quaternionf q) {
        float nw = p.w * q.w - p.x * q.x - p.y * q.y - p.z * q.z;
        float nx = p.w * q.x + p.x * q.w + p.y * q.z - p.z * q.y;
        float ny = p.w * q.y - p.x * q.z + p.y * q.w + p.z * q.x;
        float nz = p.w * q.z + p.x * q.y - p.y * q.x + p.z * q.w;
        return new Quaternionf(nx, ny, nz, nw);
    }

    public static Quaternionf getViewRotation(float pitch, float yaw) {
        Quaternionf r1 = QuaternionUtil.quaternionf(new Vector3f(1.0f, 0.0f, 0.0f), pitch, true);
        Quaternionf r2 = QuaternionUtil.quaternionf(new Vector3f(0.0f, 1.0f, 0.0f), yaw + 180.0f, true);
        return QuaternionUtil.hamiltonProduct(r1, r2);
    }

    public static Quaternionf getRotationBetween(Vec3 from, Vec3 to) {
        from = from.m_82541_();
        to = to.m_82541_();
        Vec3 axis = from.m_82537_(to).m_82541_();
        double cos = from.m_82526_(to);
        double angle = Math.acos(cos);
        return QuaternionUtil.quaternionf(axis.m_252839_(), (float)angle, false);
    }

    public static Quaternionf mult(Quaternionf a, Quaternionf b) {
        Quaternionf r = new Quaternionf((Quaternionfc)a);
        return QuaternionUtil.hamiltonProduct(r, b);
    }

    public static Quaternionf inversed(Quaternionf a) {
        Quaternionf r = new Quaternionf((Quaternionfc)a);
        r.conjugate();
        return r;
    }
}

