/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util;

import java.util.ArrayList;
import java.util.List;
import net.arna.jcraft.common.gravity.util.QuaternionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class RotationUtil {
    private static final Vec3i[] ALL_TRANSFORMATIONS = new Vec3i[]{new Vec3i(0, 1, 2), new Vec3i(0, 2, 1), new Vec3i(2, 1, 0), new Vec3i(2, 0, 1), new Vec3i(1, 2, 0), new Vec3i(1, 0, 2)};
    private static final Vec3i[] ALL_SIGNS = new Vec3i[]{new Vec3i(1, 1, 1), new Vec3i(1, 1, -1), new Vec3i(1, -1, 1), new Vec3i(1, -1, -1), new Vec3i(-1, 1, 1), new Vec3i(-1, 1, -1), new Vec3i(-1, -1, 1), new Vec3i(-1, -1, -1)};
    private static final List<VecTransform> VEC_WORLD_TO_PLAYER = new ArrayList<VecTransform>();
    private static final List<VecTransform> VEC_PLAYER_TO_WORLD = new ArrayList<VecTransform>();
    private static final Direction[][] DIR_WORLD_TO_PLAYER;
    private static final Direction[][] DIR_PLAYER_TO_WORLD;

    public static boolean approximatelyEquals(Vector3f a, Vector3f b) {
        return Mth.m_14033_((float)a.x(), (float)b.x()) && Mth.m_14033_((float)a.y(), (float)b.y()) && Mth.m_14033_((float)a.z(), (float)b.z());
    }

    private static Vector3f transform(Vector3f v, VecTransform t) {
        Vec3i position = t.pos;
        Vec3i sign = t.sign;
        float[] a = new float[]{v.x(), v.y(), v.z()};
        return new Vector3f(a[position.m_123341_()] * (float)sign.m_123341_(), a[position.m_123342_()] * (float)sign.m_123342_(), a[position.m_123343_()] * (float)sign.m_123343_());
    }

    private static Vec3 transform(Vec3 v, VecTransform t) {
        Vec3i position = t.pos;
        Vec3i sign = t.sign;
        double[] a = new double[]{v.m_7096_(), v.m_7098_(), v.m_7094_()};
        return new Vec3(a[position.m_123341_()] * (double)sign.m_123341_(), a[position.m_123342_()] * (double)sign.m_123342_(), a[position.m_123343_()] * (double)sign.m_123343_());
    }

    public static Direction dirWorldToPlayer(Direction direction, Direction gravityDirection) {
        return DIR_WORLD_TO_PLAYER[gravityDirection.m_122411_()][direction.m_122411_()];
    }

    public static Direction dirPlayerToWorld(Direction direction, Direction gravityDirection) {
        return DIR_PLAYER_TO_WORLD[gravityDirection.m_122411_()][direction.m_122411_()];
    }

    public static Vec3 vecWorldToPlayer(double x, double y, double z, Direction gravityDirection) {
        return RotationUtil.vecWorldToPlayer(new Vec3(x, y, z), gravityDirection);
    }

    public static Vec3 vecWorldToPlayer(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.transform(vec3d, VEC_WORLD_TO_PLAYER.get(gravityDirection.m_122411_()));
    }

    public static Vec3 vecPlayerToWorld(double x, double y, double z, Direction gravityDirection) {
        return RotationUtil.vecPlayerToWorld(new Vec3(x, y, z), gravityDirection);
    }

    public static Vec3 vecPlayerToWorld(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.transform(vec3d, VEC_PLAYER_TO_WORLD.get(gravityDirection.m_122411_()));
    }

    public static Vector3f vecWorldToPlayer(float x, float y, float z, Direction gravityDirection) {
        return RotationUtil.vecWorldToPlayer(new Vector3f(x, y, z), gravityDirection);
    }

    public static Vector3f vecWorldToPlayer(Vector3f vec3f, Direction gravityDirection) {
        return RotationUtil.transform(vec3f, VEC_WORLD_TO_PLAYER.get(gravityDirection.m_122411_()));
    }

    public static Vector3f vecPlayerToWorld(float x, float y, float z, Direction gravityDirection) {
        return RotationUtil.vecPlayerToWorld(new Vector3f(x, y, z), gravityDirection);
    }

    public static Vector3f vecPlayerToWorld(Vector3f vec3f, Direction gravityDirection) {
        return RotationUtil.transform(vec3f, VEC_PLAYER_TO_WORLD.get(gravityDirection.m_122411_()));
    }

    public static Vec3 maskWorldToPlayer(double x, double y, double z, Direction gravityDirection) {
        VecTransform vt = VEC_WORLD_TO_PLAYER.get(gravityDirection.m_122411_());
        vt = new VecTransform(vt.pos, new Vec3i(1, 1, 1));
        return RotationUtil.transform(new Vec3(x, y, z), vt);
    }

    public static Vec3 maskWorldToPlayer(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.maskWorldToPlayer(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, gravityDirection);
    }

    public static Vec3 maskPlayerToWorld(double x, double y, double z, Direction gravityDirection) {
        VecTransform vt = VEC_PLAYER_TO_WORLD.get(gravityDirection.m_122411_());
        vt = new VecTransform(vt.pos, new Vec3i(1, 1, 1));
        return RotationUtil.transform(new Vec3(x, y, z), vt);
    }

    public static Vec3 maskPlayerToWorld(Vec3 vec3d, Direction gravityDirection) {
        return RotationUtil.maskPlayerToWorld(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, gravityDirection);
    }

    public static AABB boxWorldToPlayer(AABB box, Direction gravityDirection) {
        return new AABB(RotationUtil.vecWorldToPlayer(box.f_82288_, box.f_82289_, box.f_82290_, gravityDirection), RotationUtil.vecWorldToPlayer(box.f_82291_, box.f_82292_, box.f_82293_, gravityDirection));
    }

    public static AABB boxPlayerToWorld(AABB box, Direction gravityDirection) {
        return new AABB(RotationUtil.vecPlayerToWorld(box.f_82288_, box.f_82289_, box.f_82290_, gravityDirection), RotationUtil.vecPlayerToWorld(box.f_82291_, box.f_82292_, box.f_82293_, gravityDirection));
    }

    public static Vec2 rotWorldToPlayer(float yaw, float pitch, Direction gravityDirection) {
        Vec3 vec3d = RotationUtil.vecWorldToPlayer(RotationUtil.rotToVec(yaw, pitch), gravityDirection);
        return RotationUtil.vecToRot(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public static Vec2 rotWorldToPlayer(Vec2 vec2f, Direction gravityDirection) {
        return RotationUtil.rotWorldToPlayer(vec2f.f_82470_, vec2f.f_82471_, gravityDirection);
    }

    public static Vec2 rotPlayerToWorld(float yaw, float pitch, Direction gravityDirection) {
        Vec3 vec3d = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(yaw, pitch), gravityDirection);
        return RotationUtil.vecToRot(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public static Vec2 rotPlayerToWorld(Vec2 vec2f, Direction gravityDirection) {
        return RotationUtil.rotPlayerToWorld(vec2f.f_82470_, vec2f.f_82471_, gravityDirection);
    }

    public static Vec3 rotToVec(float yaw, float pitch) {
        double radPitch = (double)pitch * 0.017453292;
        double radNegYaw = (double)(-yaw) * 0.017453292;
        double cosNegYaw = Math.cos(radNegYaw);
        double sinNegYaw = Math.sin(radNegYaw);
        double cosPitch = Math.cos(radPitch);
        double sinPitch = Math.sin(radPitch);
        return new Vec3(sinNegYaw * cosPitch, -sinPitch, cosNegYaw * cosPitch);
    }

    public static Vec2 vecToRot(double x, double y, double z) {
        double sinPitch = -y;
        double radPitch = Math.asin(sinPitch);
        double cosPitch = Math.cos(radPitch);
        double sinNegYaw = x / cosPitch;
        double cosNegYaw = Mth.m_14008_((double)(z / cosPitch), (double)-1.0, (double)1.0);
        double radNegYaw = Math.acos(cosNegYaw);
        if (sinNegYaw < 0.0) {
            radNegYaw = Math.PI * 2 - radNegYaw;
        }
        return new Vec2(Mth.m_14177_((float)((float)(-radNegYaw) / ((float)Math.PI / 180))), (float)radPitch / ((float)Math.PI / 180));
    }

    public static Vec2 vecToRot(Vec3 vec3d) {
        return RotationUtil.vecToRot(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    public static Quaternionf getWorldRotationQuaternion(Direction gravityDirection) {
        return RotationUtil.getRotationBetween(gravityDirection, Direction.DOWN);
    }

    public static Quaternionf getCameraRotationQuaternion(Direction gravityDirection) {
        return RotationUtil.getRotationBetween(Direction.DOWN, gravityDirection);
    }

    public static Quaternionf getRotationBetween(Direction d1, Direction d2) {
        Vec3 start = new Vec3(d1.m_253071_());
        Vec3 end = new Vec3(d2.m_253071_());
        if (d1.m_122424_() == d2) {
            return QuaternionUtil.quaternionf(new Vector3f(0.0f, 0.0f, -1.0f), 180.0f, true);
        }
        return QuaternionUtil.getRotationBetween(start, end);
    }

    public static Quaternionf multiply(Quaternionf quat, float val) {
        return new Quaternionf(quat.x() * val, quat.y() * val, quat.z() * val, quat.w() * val);
    }

    public static Quaternionf add(Quaternionf a, Quaternionf q) {
        return new Quaternionf(a.x() + q.x(), a.y() + q.y(), a.z() + q.z(), a.w() + q.w());
    }

    public static float dotProduct(Quaternionf a, Quaternionf q) {
        return a.x() * q.x() + a.y() * q.y() + a.z() * q.z() + a.w() * q.w();
    }

    public static Quaternionf getNormalized(Quaternionf a) {
        float lenSq = RotationUtil.dotProduct(a, a);
        if (lenSq != 0.0f) {
            double len = Math.sqrt(lenSq);
            return RotationUtil.multiply(a, 1.0f / (float)len);
        }
        return new Quaternionf(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Quaternionf interpolate(Quaternionf a, Quaternionf b, float t) {
        float DOT_THRESHOLD;
        float dot = RotationUtil.dotProduct(a, b);
        if (dot < 0.0f) {
            a = RotationUtil.multiply(a, -1.0f);
            dot = -dot;
        }
        if (dot > (DOT_THRESHOLD = 0.9995f)) {
            return RotationUtil.getNormalized(RotationUtil.add(RotationUtil.multiply(a, 1.0f - t), RotationUtil.multiply(b, t)));
        }
        float theta_0 = (float)Math.acos(dot);
        float theta = theta_0 * t;
        float sin_theta = (float)Math.sin(theta);
        float sin_theta_0 = (float)Math.sin(theta_0);
        float s0 = (float)Math.cos(theta) - dot * sin_theta / sin_theta_0;
        float s1 = sin_theta / sin_theta_0;
        return RotationUtil.add(RotationUtil.multiply(a, s0), RotationUtil.multiply(b, s1));
    }

    static {
        for (Direction d : Direction.values()) {
            Vector3f cameraRotation = new Vector3f(1.0f, 2.0f, 3.0f);
            cameraRotation.rotate((Quaternionfc)RotationUtil.getCameraRotationQuaternion(d));
            Vector3f worldRotation = new Vector3f(1.0f, 2.0f, 3.0f);
            worldRotation.rotate((Quaternionfc)RotationUtil.getWorldRotationQuaternion(d));
            Vector3f test = new Vector3f(1.0f, 2.0f, 3.0f);
            for (Vec3i pos : ALL_TRANSFORMATIONS) {
                for (Vec3i sign : ALL_SIGNS) {
                    VecTransform vt = new VecTransform(pos, sign);
                    if (RotationUtil.approximatelyEquals(worldRotation, RotationUtil.transform(test, vt))) {
                        VEC_WORLD_TO_PLAYER.add(vt);
                    }
                    if (!RotationUtil.approximatelyEquals(cameraRotation, RotationUtil.transform(test, vt))) continue;
                    VEC_PLAYER_TO_WORLD.add(vt);
                }
            }
        }
        DIR_WORLD_TO_PLAYER = new Direction[6][];
        for (Direction gravityDirection : Direction.values()) {
            RotationUtil.DIR_WORLD_TO_PLAYER[gravityDirection.m_122411_()] = new Direction[6];
            for (Direction direction : Direction.values()) {
                Vec3 directionVector = Vec3.m_82528_((Vec3i)direction.m_122436_());
                directionVector = RotationUtil.vecWorldToPlayer(directionVector, gravityDirection);
                BlockPos vec = BlockPos.m_274446_((Position)directionVector);
                RotationUtil.DIR_WORLD_TO_PLAYER[gravityDirection.m_122411_()][direction.m_122411_()] = Direction.m_122378_((int)vec.m_123341_(), (int)vec.m_123342_(), (int)vec.m_123343_());
            }
        }
        DIR_PLAYER_TO_WORLD = new Direction[6][];
        for (Direction gravityDirection : Direction.values()) {
            RotationUtil.DIR_PLAYER_TO_WORLD[gravityDirection.m_122411_()] = new Direction[6];
            for (Direction direction : Direction.values()) {
                Vec3 directionVector = Vec3.m_82528_((Vec3i)direction.m_122436_());
                directionVector = RotationUtil.vecPlayerToWorld(directionVector, gravityDirection);
                BlockPos vec = BlockPos.m_274446_((Position)directionVector);
                RotationUtil.DIR_PLAYER_TO_WORLD[gravityDirection.m_122411_()][direction.m_122411_()] = Direction.m_122378_((int)vec.m_123341_(), (int)vec.m_123342_(), (int)vec.m_123343_());
            }
        }
    }

    record VecTransform(Vec3i pos, Vec3i sign) {
    }
}

