/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util.packet;

import net.arna.jcraft.api.component.entity.CommonGravityComponent;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.NetworkUtil;
import net.arna.jcraft.common.gravity.util.packet.GravityPacket;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;

public class DefaultGravityPacket
extends GravityPacket {
    public final Direction direction;
    public final RotationParameters rotationParameters;
    public final boolean initialGravity;

    public DefaultGravityPacket(Direction _direction, RotationParameters _rotationParameters, boolean _initialGravity) {
        this.direction = _direction;
        this.rotationParameters = _rotationParameters;
        this.initialGravity = _initialGravity;
    }

    public DefaultGravityPacket(FriendlyByteBuf buf) {
        this(NetworkUtil.readDirection(buf), NetworkUtil.readRotationParameters(buf), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        NetworkUtil.writeDirection(buf, this.direction);
        NetworkUtil.writeRotationParameters(buf, this.rotationParameters);
        buf.writeBoolean(this.initialGravity);
    }

    @Override
    public void run(CommonGravityComponent gc) {
        gc.setDefaultGravityDirection(this.direction, this.rotationParameters, this.initialGravity);
    }

    @Override
    public RotationParameters getRotationParameters() {
        return this.rotationParameters;
    }
}

