/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util.packet;

import net.arna.jcraft.api.component.entity.CommonGravityComponent;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.NetworkUtil;
import net.arna.jcraft.common.gravity.util.packet.GravityPacket;
import net.minecraft.network.FriendlyByteBuf;

public class InvertGravityPacket
extends GravityPacket {
    public final boolean inverted;
    public final RotationParameters rotationParameters;
    public final boolean initialGravity;

    public InvertGravityPacket(boolean _inverted, RotationParameters _rotationParameters, boolean _initialGravity) {
        this.inverted = _inverted;
        this.rotationParameters = _rotationParameters;
        this.initialGravity = _initialGravity;
    }

    public InvertGravityPacket(FriendlyByteBuf buf) {
        this(buf.readBoolean(), NetworkUtil.readRotationParameters(buf), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.inverted);
        NetworkUtil.writeRotationParameters(buf, this.rotationParameters);
        buf.writeBoolean(this.initialGravity);
    }

    @Override
    public void run(CommonGravityComponent gc) {
        gc.invertGravity(this.inverted, this.rotationParameters, this.initialGravity);
    }

    @Override
    public RotationParameters getRotationParameters() {
        return this.rotationParameters;
    }
}

