/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util.packet;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.arna.jcraft.api.component.entity.CommonGravityComponent;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.gravity.util.NetworkUtil;
import net.arna.jcraft.common.gravity.util.packet.GravityPacket;
import net.minecraft.network.FriendlyByteBuf;

public class OverwriteGravityPacket
extends GravityPacket {
    public final List<Gravity> gravityList;
    public final boolean initialGravity;

    public OverwriteGravityPacket(List<Gravity> _gravityList, boolean _initialGravity) {
        this.gravityList = _gravityList;
        this.initialGravity = _initialGravity;
    }

    public OverwriteGravityPacket(FriendlyByteBuf buf) {
        int listSize = buf.readInt();
        this.gravityList = new ArrayList<Gravity>();
        for (int i = 0; i < listSize; ++i) {
            this.gravityList.add(NetworkUtil.readGravity(buf));
        }
        this.initialGravity = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.gravityList.size());
        for (Gravity gravity : this.gravityList) {
            NetworkUtil.writeGravity(buf, gravity);
        }
        buf.writeBoolean(this.initialGravity);
    }

    @Override
    public void run(CommonGravityComponent gc) {
        gc.setGravity(this.gravityList, this.initialGravity);
    }

    @Override
    public RotationParameters getRotationParameters() {
        Optional<Gravity> max = this.gravityList.stream().max(Comparator.comparingInt(Gravity::priority));
        if (max.isEmpty()) {
            return new RotationParameters();
        }
        return max.get().rotationParameters();
    }
}

