/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.util.packet;

import net.arna.jcraft.api.component.entity.CommonGravityComponent;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.gravity.util.NetworkUtil;
import net.arna.jcraft.common.gravity.util.packet.GravityPacket;
import net.minecraft.network.FriendlyByteBuf;

public class UpdateGravityPacket
extends GravityPacket {
    public final Gravity gravity;
    public final boolean initialGravity;

    public UpdateGravityPacket(Gravity _gravity, boolean _initialGravity) {
        this.gravity = _gravity;
        this.initialGravity = _initialGravity;
    }

    public UpdateGravityPacket(FriendlyByteBuf buf) {
        this(NetworkUtil.readGravity(buf), buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        NetworkUtil.writeGravity(buf, this.gravity);
        buf.writeBoolean(this.initialGravity);
    }

    @Override
    public void run(CommonGravityComponent gc) {
        gc.addGravity(this.gravity, this.initialGravity);
    }

    @Override
    public RotationParameters getRotationParameters() {
        return this.gravity.rotationParameters();
    }
}

