/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AnubisItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public AnubisItem(Item.Properties settings) {
        super(settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 6.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.m_7500_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)"jcraft.anubis.namedesc"));
        tooltip.add((Component)Component.m_237115_((String)"jcraft.anubis.bloodthirstdesc"));
        tooltip.add((Component)Component.m_237115_((String)"jcraft.anubis.removaldesc"));
        tooltip.add((Component)Component.m_237115_((String)"jcraft.anubis.desc"));
        super.m_7373_(stack, world, tooltip, context);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack item = user.m_21120_(hand);
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)user);
        if (user.m_6144_() || world.f_46443_ || stand != null && stand.blocking) {
            return InteractionResultHolder.m_19100_((Object)item);
        }
        JUtils.serverPlaySound((SoundEvent)JSoundRegistry.ANUBIS_SHEATHE.get(), (ServerLevel)world, user.m_20182_());
        user.m_21008_(hand, new ItemStack((ItemLike)JItemRegistry.ANUBIS_SHEATHED.get()));
        return InteractionResultHolder.m_19090_((Object)item);
    }

    public static void handleAnubisEffects(int timeSinceAttack, Player player) {
        if (timeSinceAttack > -6000) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 20, 0, true, false));
        } else if (timeSinceAttack < -12000) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 20, 0, true, false));
            if (timeSinceAttack < -18000) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 0, true, false));
                if (timeSinceAttack < -24000) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 20, 0, true, false));
                    if (timeSinceAttack < -30000) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0, true, false));
                    }
                }
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (world.f_46443_) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AnubisItem.handleAnubisEffects(player.m_21215_() - player.f_19797_, player);
        }
    }
}

