/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import java.util.List;
import net.arna.jcraft.api.component.living.CommonVampireComponent;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class BloodBottleItem
extends Item {
    private static final int MAX_USE_TIME = 24;
    public static final float MAX_BLOOD = 16.0f;

    public BloodBottleItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)user, (InteractionHand)hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        CommonVampireComponent vampireComponent;
        Player playerEntity = user instanceof Player ? (Player)user : null;
        CompoundTag nbt = stack.m_41784_();
        float blood = nbt.m_128457_("Blood");
        if (blood >= 0.5f && (vampireComponent = JComponentPlatformUtils.getVampirism((LivingEntity)playerEntity)).isVampire()) {
            boolean full;
            boolean bl = full = blood >= 1.0f;
            if (playerEntity != null) {
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!playerEntity.m_150110_().f_35937_ && vampireComponent.getBlood() < 20.0f) {
                    nbt.m_128350_("Blood", Math.max(blood -= 1.0f, 0.0f));
                }
            }
            if (!world.f_46443_) {
                if (playerEntity instanceof ServerPlayer) {
                    CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)playerEntity, stack);
                }
                vampireComponent.setBlood(vampireComponent.getBlood() + (float)(full ? 2 : 1));
            }
            user.m_146850_(GameEvent.f_223704_);
        }
        return stack;
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        stack.m_41784_().m_128350_("Blood", 0.0f);
        return stack;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if ((double)stack.m_41784_().m_128457_("Blood") >= 0.5) {
            return UseAnim.DRINK;
        }
        return UseAnim.NONE;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Blood")) {
            tooltip.add((Component)Component.m_237119_().m_7220_((Component)Component.m_237115_((String)"jcraft.blood_bottle.units")).m_7220_((Component)Component.m_237113_((String)" ")).m_130946_(nbt.m_128457_("Blood") + "/16.0"));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public InteractionResult m_6880_(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        if (user.m_36335_().m_41519_((Item)this) || !JUtils.canAct((LivingEntity)user)) {
            return InteractionResult.PASS;
        }
        float bloodMult = JUtils.getBloodMult(entity);
        if (bloodMult <= 0.0f) {
            return InteractionResult.PASS;
        }
        user.m_36335_().m_41524_((Item)this, 15);
        if (!user.m_9236_().m_5776_()) {
            entity.m_6469_(user.m_9236_().m_269111_().m_269075_(user), 2.0f);
            CompoundTag nbtCompound = stack.m_41784_();
            float newBlood = nbtCompound.m_128457_("Blood") + bloodMult;
            if (newBlood > 16.0f) {
                newBlood = 16.0f;
            }
            nbtCompound.m_128350_("Blood", newBlood);
            user.m_21008_(hand, stack);
        }
        return InteractionResult.SUCCESS;
    }

    public int m_8105_(ItemStack stack) {
        return 24;
    }
}

