/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.renderer.GeoArmorRenderer;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.client.renderer.armor.DIOCapeRenderer;
import net.arna.jcraft.client.renderer.armor.GyroTopRenderer;
import net.arna.jcraft.client.renderer.armor.HeavenAttainedArmorRenderer;
import net.arna.jcraft.client.renderer.armor.JotaroCoatP4Renderer;
import net.arna.jcraft.client.renderer.armor.JotaroCoatRenderer;
import net.arna.jcraft.client.renderer.armor.RisottoTopRenderer;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class FlutteringArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public FlutteringArmorItem(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
    }

    private PlayState predicate(AnimationState<FlutteringArmorItem> state) {
        Player player;
        Entity entity = (Entity)state.getData(DataTickets.ENTITY);
        boolean moving = entity instanceof Player ? !JUtils.deltaPos((Entity)(player = (Player)entity)).equals((Object)Vec3.f_82478_) : entity.m_20184_().m_165925_() > 0.01;
        state.getController().setAnimation(RawAnimation.begin().thenLoop(moving ? "animation.moving" : "animation.idle"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoArmorRenderer<?> renderer;

            @NonNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
                if (this.renderer == null) {
                    this.renderer = itemStack.m_150930_((Item)JItemRegistry.DIO_CAPE.get()) ? new DIOCapeRenderer() : (itemStack.m_150930_((Item)JItemRegistry.JOTARO_JACKET.get()) ? new JotaroCoatRenderer() : (itemStack.m_150930_((Item)JItemRegistry.JOTARO_P4_JACKET.get()) ? new JotaroCoatP4Renderer() : (itemStack.m_150930_((Item)JItemRegistry.HEAVEN_ATTAINED_SHIRT.get()) ? new HeavenAttainedArmorRenderer() : (itemStack.m_150930_((Item)JItemRegistry.RISOTTO_JACKET.get()) ? new RisottoTopRenderer() : new GyroTopRenderer()))));
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }
}

