/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.renderer.GeoArmorRenderer;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.client.renderer.armor.KarsArmorRenderer;
import net.arna.jcraft.client.renderer.armor.PuccisHatRenderer;
import net.arna.jcraft.client.renderer.armor.RedHatRenderer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HatItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public HatItem(ArmorMaterial materialIn, Item.Properties builder) {
        super(materialIn, ArmorItem.Type.HELMET, builder);
    }

    public boolean m_6832_(@NonNull ItemStack stack, ItemStack ingredient) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (ingredient.m_150930_(Items.f_42454_)) {
            return true;
        }
        return super.m_6832_(stack, ingredient);
    }

    public void m_7373_(@NonNull ItemStack stack, @Nullable Level world, @NonNull List<Component> tooltip, @NonNull TooltipFlag context) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (tooltip == null) {
            throw new NullPointerException("tooltip is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.m_7968_().m_204117_(JTagRegistry.PROTECTS_FROM_SUN)) {
            tooltip.add((Component)Component.m_237115_((String)"jcraft.sunprotection.desc"));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, this::predicate)});
    }

    private PlayState predicate(AnimationState<HatItem> animationState) {
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoArmorRenderer<?> renderer;

            @NonNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
                if (this.renderer == null) {
                    if (itemStack.m_150930_((Item)JItemRegistry.KARS_HEADWRAP.get())) {
                        this.renderer = new KarsArmorRenderer();
                    }
                    if (itemStack.m_150930_((Item)JItemRegistry.RED_HAT.get())) {
                        this.renderer = new RedHatRenderer();
                    }
                    if (itemStack.m_150930_((Item)JItemRegistry.PUCCIS_HAT.get())) {
                        this.renderer = new PuccisHatRenderer();
                    }
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }
}

