/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.projectile.KnifeProjectile;
import net.arna.jcraft.common.item.KnifeItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class KnifeBundleItem
extends KnifeItem {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public KnifeBundleItem(Item.Properties settings) {
        super(settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 6.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.8, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    @Override
    protected float getChargeTime() {
        return 20.0f;
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            return;
        }
        if (!world.f_46443_) {
            float speedMult = this.getSpeedMult(stack, remainingUseTicks);
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)user;
                serverPlayer.m_36335_().m_41524_((Item)this, 60);
                serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!serverPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            RandomSource random = RandomSource.m_216327_();
            for (int i = 0; i < 9; ++i) {
                KnifeProjectile knife = new KnifeProjectile(world, user);
                knife.m_146884_(knife.m_20182_().m_82520_(random.m_216328_(0.0, 0.5), random.m_216328_(0.0, 0.5), random.m_216328_(0.0, 0.5)));
                knife.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.5f * speedMult, 5.0f);
                world.m_7967_((Entity)knife);
            }
        } else {
            world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11857_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }
}

