/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.projectile.KnifeProjectile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class KnifeItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public KnifeItem(Item.Properties settings) {
        super(settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 4.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.2, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public int m_8105_(ItemStack stack) {
        return 7200;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    protected float getSpeedMult(ItemStack stack, int remainingUseTicks) {
        float speedMult = this.m_8105_(stack) - remainingUseTicks;
        if (speedMult > this.getChargeTime()) {
            speedMult = this.getChargeTime();
        }
        return speedMult /= this.getChargeTime();
    }

    protected float getChargeTime() {
        return 10.0f;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)"jcraft.knife.chargetime").m_130946_(" \u00a7e" + this.getChargeTime() / 20.0f + "\u00a79s"));
        super.m_7373_(stack, world, tooltip, context);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            return;
        }
        if (!world.f_46443_) {
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)user;
                serverPlayer.m_36335_().m_41524_((Item)this, 15);
                serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!serverPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            KnifeProjectile knife = new KnifeProjectile(world, user);
            knife.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.5f * this.getSpeedMult(stack, remainingUseTicks), 0.0f);
            world.m_7967_((Entity)knife);
        } else {
            world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11857_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.m_7500_();
    }

    public boolean m_8096_(BlockState state) {
        return state.m_60713_(Blocks.f_50033_);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }
}

