/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import java.util.List;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.projectile.BulletProjectile;
import net.arna.jcraft.common.tickable.PeacemakerReload;
import net.arna.jcraft.common.tickable.RevolverFire;
import net.arna.jcraft.common.util.DimensionData;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Peacemaker
extends Item {
    public static final String SHOTS_ID = "Shots";
    public static final String RELOADING_ID = "Reloading";
    public static final int MAX_ROUNDS = 6;

    public Peacemaker(Item.Properties settings) {
        super(settings);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        CompoundTag itemData = stack.m_41783_();
        if (itemData != null && itemData.m_128441_(SHOTS_ID)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.jcraft.peacemaker.shots").m_130946_(" \u00a7e" + String.valueOf(itemData.m_128423_(SHOTS_ID))));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        CompoundTag data = itemStack.m_41784_();
        int shots = data.m_128451_(SHOTS_ID);
        if (shots >= 6) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (data.m_128471_(RELOADING_ID) && user.m_36335_().m_41519_((Item)JItemRegistry.PEACEMAKER.get())) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (!user.m_7500_() && !Peacemaker.hasBulletInInventory(user)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (!world.f_46443_) {
            data.m_128379_(RELOADING_ID, true);
            user.m_36335_().m_41524_((Item)JItemRegistry.PEACEMAKER.get(), 60);
            PeacemakerReload.enqueue(new DimensionData((LivingEntity)user, (ResourceKey<Level>)world.m_46472_(), 10));
            world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)JSoundRegistry.LOAD.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public static boolean handleLeftClick(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        ItemStack peacemakerStack = null;
        if (mainHand.m_41720_() instanceof Peacemaker) {
            peacemakerStack = mainHand;
        } else if (offHand.m_41720_() instanceof Peacemaker) {
            peacemakerStack = offHand;
        }
        if (peacemakerStack == null) {
            return false;
        }
        Level world = player.m_9236_();
        if (player.m_36335_().m_41519_((Item)JItemRegistry.PEACEMAKER.get())) {
            return true;
        }
        if (player.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            return true;
        }
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
        if (stand != null && stand.getMoveStun() > 0) {
            return true;
        }
        JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)player);
        if (spec != null && spec.getMoveStun() > 0) {
            return true;
        }
        CompoundTag data = peacemakerStack.m_41784_();
        int shots = data.m_128451_(SHOTS_ID);
        if (data.m_128471_(RELOADING_ID)) {
            return true;
        }
        if (shots < 1 && !player.m_7500_()) {
            return true;
        }
        if (!world.f_46443_) {
            player.m_36335_().m_41524_((Item)JItemRegistry.PEACEMAKER.get(), 10);
            RevolverFire.enqueue(new DimensionData((LivingEntity)player, (ResourceKey<Level>)world.m_46472_(), 3));
        }
        return true;
    }

    public static void fireStatic(ItemStack itemStack, Level world, LivingEntity user) {
        Player player;
        CompoundTag data = itemStack.m_41784_();
        int shots = data.m_128451_(SHOTS_ID);
        if (!(user instanceof Player) || !(player = (Player)user).m_7500_()) {
            if (shots < 1) {
                return;
            }
            data.m_128405_(SHOTS_ID, shots - 1);
        }
        world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)JSoundRegistry.REVOLVER_FIRE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        BulletProjectile bullet = new BulletProjectile(world, user, 9.0f, 10.0f, 2, 5.0f);
        bullet.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 10.0f, 0.0f);
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            double bulletX = bullet.m_20185_();
            double bulletY = bullet.m_20186_();
            double bulletZ = bullet.m_20189_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, bulletX, bulletY, bulletZ, 5, 0.1, 0.1, 0.1, 0.02);
        }
        world.m_7967_((Entity)bullet);
        if (user instanceof Player) {
            Player player2 = (Player)user;
            player2.m_36335_().m_41524_((Item)JItemRegistry.PEACEMAKER.get(), 20);
            player2.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)JItemRegistry.PEACEMAKER.get())));
        }
    }

    public static void finishReload(ItemStack itemStack, Level world, LivingEntity user) {
        CompoundTag data = itemStack.m_41784_();
        int shots = data.m_128451_(SHOTS_ID);
        if (shots >= 6) {
            data.m_128379_(RELOADING_ID, false);
            return;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            if (Peacemaker.consumeBulletFromInventory(player)) {
                data.m_128405_(SHOTS_ID, shots + 1);
                world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)JSoundRegistry.LOAD.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
                if (data.m_128451_(SHOTS_ID) < 6 && Peacemaker.hasBulletInInventory(player)) {
                    PeacemakerReload.enqueue(new DimensionData(user, (ResourceKey<Level>)world.m_46472_(), 10));
                    player.m_36335_().m_41524_((Item)JItemRegistry.PEACEMAKER.get(), 60);
                } else {
                    data.m_128379_(RELOADING_ID, false);
                    player.m_36335_().m_41527_((Item)JItemRegistry.PEACEMAKER.get());
                }
            } else {
                data.m_128379_(RELOADING_ID, false);
                player.m_36335_().m_41527_((Item)JItemRegistry.PEACEMAKER.get());
            }
        }
    }

    private static boolean hasBulletInInventory(Player player) {
        return player.m_150109_().m_36063_(new ItemStack((ItemLike)JItemRegistry.BULLET.get()));
    }

    private static boolean consumeBulletFromInventory(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != JItemRegistry.BULLET.get()) continue;
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(SHOTS_ID, 6);
        nbt.m_128379_(RELOADING_ID, false);
        return stack;
    }
}

