/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.item.AnubisItem;
import net.arna.jcraft.common.item.SpecObtainmentItem;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SheathedAnubisItem
extends SpecObtainmentItem {
    public SheathedAnubisItem(Item.Properties settings, RegistrySupplier<SpecType> spec) {
        super(settings, spec);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, List<Component> tooltip, @NotNull TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)"jcraft.anubis.namedesc"));
        tooltip.add((Component)Component.m_237115_((String)"jcraft.anubis.bloodthirstdesc"));
        tooltip.add((Component)Component.m_237115_((String)"jcraft.anubis.removaldesc"));
        tooltip.add((Component)Component.m_237115_((String)"jcraft.sheathedanubis.blockdesc"));
        tooltip.add((Component)Component.m_237115_((String)"jcraft.sheathedanubis.desc"));
        super.m_7373_(stack, world, tooltip, context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player user, @NotNull InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (user.m_6144_()) {
            user.m_6672_(hand);
        } else {
            if (world.f_46443_) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)user);
            if (stand != null && stand.blocking) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            ServerLevel serverWorld = (ServerLevel)world;
            boolean specChanged = this.tryGetSpec(user);
            if (specChanged) {
                JUtils.serverPlaySound((SoundEvent)JSoundRegistry.ANUBIS_UNSHEATHE.get(), serverWorld, user.m_20182_());
                JUtils.serverPlaySound((SoundEvent)JSoundRegistry.ANUBIS_SPECCHANGE.get(), serverWorld, user.m_20182_());
                user.m_21008_(hand, new ItemStack((ItemLike)JItemRegistry.ANUBIS.get()));
            } else if (!this.warned) {
                JUtils.serverPlaySound((SoundEvent)JSoundRegistry.ANUBIS_UNSHEATHE.get(), serverWorld, user.m_20182_());
                user.m_21008_(hand, new ItemStack((ItemLike)JItemRegistry.ANUBIS.get()));
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (world.f_46443_) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AnubisItem.handleAnubisEffects(player.m_21215_() - player.f_19797_, player);
        }
    }
}

