/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import java.util.List;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.player.CommonSpecComponent;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.spec.SpecData;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.api.spec.SpecTypeUtil;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecDiscItem
extends Item {
    private static final String SPEC_ID = "SpecID";

    public SpecDiscItem(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }

    @NonNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, @NonNull InteractionHand hand) {
        CommonSpecComponent specData;
        SpecType userSpec;
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        ItemStack itemStack = user.m_21120_(hand);
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (JCraft.wasRecentlyAttacked(user.m_21231_())) {
            user.m_5661_((Component)Component.m_237115_((String)"jcraft.disc.combat"), true);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        CompoundTag data = itemStack.m_41784_();
        SpecType itemSpec = SpecTypeUtil.readFromNBT(data, SPEC_ID);
        if (itemSpec == (userSpec = (specData = JComponentPlatformUtils.getSpecData((LivingEntity)user)).getType()) && itemSpec != null) {
            user.m_5661_((Component)Component.m_237115_((String)"jcraft.disc.same_spec"), true);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        specData.setType(itemSpec);
        if (userSpec == null) {
            data.m_128473_(SPEC_ID);
        } else {
            data.m_128359_(SPEC_ID, userSpec.getId().toString());
        }
        user.m_36335_().m_41524_((Item)this, 20);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        SpecType type = SpecDiscItem.getSpecType(stack);
        if (type == null) {
            tooltip.add((Component)Component.m_237113_((String)"Empty").m_130938_(s -> s.m_131157_(ChatFormatting.GRAY)));
            return;
        }
        SpecData data = type.getData();
        tooltip.add((Component)data.getName().m_6881_().m_130938_(s -> s.m_131140_(ChatFormatting.GRAY)));
    }

    public static ItemStack createDiscStack(SpecType type) {
        ItemStack stack = new ItemStack((ItemLike)JItemRegistry.SPEC_DISC.get());
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_(SPEC_ID, type.getId().toString());
        return stack;
    }

    public static boolean isEmptyDisc(ItemStack stack) {
        return stack.m_41783_() == null || !stack.m_41783_().m_128425_(SPEC_ID, 3);
    }

    public static SpecType getSpecType(ItemStack stack) {
        if (!stack.m_150930_((Item)JItemRegistry.SPEC_DISC.get())) {
            return null;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_(SPEC_ID)) {
            return null;
        }
        return SpecTypeUtil.readFromNBT(nbt, SPEC_ID);
    }
}

