/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import dev.architectury.registry.registries.RegistrySupplier;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public abstract class SpecObtainmentItem
extends Item {
    protected boolean warned = false;
    protected final RegistrySupplier<SpecType> switchTo;

    public SpecObtainmentItem(Item.Properties settings, RegistrySupplier<SpecType> switchTo) {
        super(settings);
        this.switchTo = switchTo;
    }

    private boolean setSpec(Player player) {
        if (player == null) {
            return false;
        }
        JComponentPlatformUtils.getSpecData((LivingEntity)player).setType((SpecType)this.switchTo.get());
        if (!player.m_9236_().m_5776_()) {
            player.m_36220_((ResourceLocation)JStatRegistry.SPECS_CHANGED.get());
        }
        this.warned = false;
        return true;
    }

    protected boolean tryGetSpec(Player player) {
        JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)player);
        if (spec != null) {
            if (spec.getType() != this.switchTo.get()) {
                if (!this.warned) {
                    player.m_213846_((Component)Component.m_237115_((String)"warning.jcraft.spec.change"));
                    this.warned = true;
                    return false;
                }
                return this.setSpec(player);
            }
            return false;
        }
        return this.setSpec(player);
    }
}

