/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.projectile.StandArrowEntity;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StandArrowItem
extends ArrowItem {
    public static final ResourceKey<DamageType> STAND_ARROW = JDamageSources.createDamageType("stand_arrow");
    protected Set<Player> warned = Collections.newSetFromMap(new WeakHashMap());

    public StandArrowItem(Item.Properties settings) {
        super(settings);
    }

    @NonNull
    public UseAnim m_6164_(@NonNull ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        return UseAnim.EAT;
    }

    @NonNull
    public InteractionResultHolder<ItemStack> m_7203_(@NonNull Level world, @NonNull Player user, @NonNull InteractionHand hand) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        CommonStandComponent standData = JComponentPlatformUtils.getStandComponent((LivingEntity)user);
        StandEntity<?, ?> oldStand = standData.getStand();
        ItemStack itemStack = user.m_21120_(hand);
        if (!StandTypeUtil.isNone(standData.getType()) && !this.warned.contains(user)) {
            if (!world.m_5776_()) {
                user.m_213846_((Component)Component.m_237115_((String)"warning.jcraft.stand.change"));
                this.warned.add(user);
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (!user.m_7500_()) {
            itemStack.m_41774_(1);
        }
        user.m_36335_().m_41524_((Item)this, 20);
        int damage = Math.max(world.m_46469_().m_46215_(JCraft.STAND_ARROW_BASE_DAMAGE), 0);
        if (world.m_46791_() == Difficulty.HARD) {
            damage *= 2;
        } else if (world.m_46791_() == Difficulty.EASY) {
            damage /= 2;
        } else if (world.m_46791_() == Difficulty.PEACEFUL) {
            damage = 0;
        }
        if (damage > 0) {
            user.m_6469_(JDamageSources.create(world, STAND_ARROW, (Entity)user), (float)damage);
        }
        if (!world.m_5776_()) {
            StandType newType;
            this.warned.remove(user);
            if (oldStand != null) {
                oldStand.desummon();
                oldStand.m_146870_();
            }
            RandomSource random = RandomSource.m_216327_();
            StandType oldType = standData.getType();
            while ((newType = StandTypeUtil.getRandomRegular(random)) == oldType) {
            }
            standData.setType(newType);
            JCraft.summon(world, (LivingEntity)user);
            user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @NonNull
    public AbstractArrow m_6394_(@NonNull Level level, @NonNull ItemStack stack, @Nullable LivingEntity shooter) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (!(shooter instanceof ServerPlayer)) {
            stack.m_41774_(1);
        }
        return new StandArrowEntity(shooter, level);
    }
}

