/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import java.util.List;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandDiscItem
extends Item {
    private static final TextColor[] SKIN_LEVEL_COLORS = new TextColor[]{TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY), TextColor.m_131270_((ChatFormatting)ChatFormatting.RED), TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE), TextColor.m_131270_((ChatFormatting)ChatFormatting.LIGHT_PURPLE)};
    private static final Component DEFAULT_SKIN = Component.m_237113_((String)"Default");

    public StandDiscItem(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }

    @NonNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, @NonNull InteractionHand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        ItemStack itemStack = user.m_21120_(hand);
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (JCraft.wasRecentlyAttacked(user.m_21231_())) {
            user.m_5661_((Component)Component.m_237115_((String)"jcraft.disc.combat"), true);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        int itemSkin = 0;
        CompoundTag data = itemStack.m_41784_();
        StandType itemStand = StandTypeUtil.readFromNBT(data, "StandID");
        if (data.m_128425_("Skin", 3)) {
            itemSkin = data.m_128451_("Skin");
        }
        if (itemStand != null && JCraft.getExclusiveStandsData().isStandUsed(itemStand)) {
            user.m_5661_((Component)Component.m_237115_((String)"jcraft.disc.stand_in_use"), true);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        CommonStandComponent standData = JComponentPlatformUtils.getStandComponent((LivingEntity)user);
        StandType userStand = standData.getType();
        int userSkin = standData.getSkin();
        if (itemStand == userStand && (itemStand == null || itemSkin == userSkin)) {
            if (itemStand != null) {
                user.m_5661_((Component)Component.m_237115_((String)"jcraft.disc.same_stand"), true);
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        standData.setTypeAndSkin(itemStand, itemSkin);
        if (userStand == null) {
            data.m_128473_("StandID");
            data.m_128473_("Skin");
        } else {
            data.m_128359_("StandID", userStand.getId().toString());
            data.m_128405_("Skin", userSkin);
        }
        StandEntity<?, ?> stand = standData.getStand();
        if (stand != null) {
            stand.desummon();
            if (!stand.m_213877_()) {
                stand.m_146870_();
            }
            standData.setStand(null);
        }
        JCraft.summon(world, (LivingEntity)user);
        user.m_36335_().m_41524_((Item)this, 20);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        StandType type = StandDiscItem.getStandType(stack);
        if (type == null) {
            tooltip.add((Component)Component.m_237113_((String)"Empty").m_130938_(s -> s.m_131157_(ChatFormatting.GRAY)));
            return;
        }
        StandData data = type.getData();
        tooltip.add((Component)data.getInfo().getName().m_6881_().m_130938_(s -> s.m_131140_(data.isEvolution() ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.GRAY)));
        int skin = StandDiscItem.getSkin(stack);
        tooltip.add((Component)(skin == 0 || skin >= data.getInfo().getSkinCount() ? DEFAULT_SKIN : data.getInfo().getSkinNames().get(skin - 1)).m_6881_().m_130938_(s -> s.m_131148_(SKIN_LEVEL_COLORS[skin])));
    }

    public static ItemStack createDiscStack(StandType type, int skin) {
        if (skin < 0 || skin >= type.getData().getInfo().getSkinCount()) {
            throw new IndexOutOfBoundsException("Skin out of bounds");
        }
        ItemStack stack = new ItemStack((ItemLike)JItemRegistry.STAND_DISC.get());
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("StandID", type.getId().toString());
        nbt.m_128405_("Skin", skin);
        return stack;
    }

    public static boolean isEmptyDisc(ItemStack stack) {
        return stack.m_41783_() == null || !stack.m_41783_().m_128425_("StandID", 3);
    }

    public static StandType getStandType(ItemStack stack) {
        if (!stack.m_150930_((Item)JItemRegistry.STAND_DISC.get())) {
            return null;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_("StandID")) {
            return null;
        }
        return StandTypeUtil.readFromNBT(nbt, "StandID");
    }

    public static void setSkin(ItemStack stack, int skin) {
        if (!stack.m_150930_((Item)JItemRegistry.STAND_DISC.get())) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_("Skin", skin);
    }

    public static int getSkin(ItemStack stack) {
        if (!stack.m_150930_((Item)JItemRegistry.STAND_DISC.get())) {
            return 0;
        }
        CompoundTag nbt = stack.m_41783_();
        return nbt == null || !nbt.m_128425_("Skin", 3) ? 0 : nbt.m_128451_("Skin");
    }
}

