/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.renderer.GeoArmorRenderer;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.player.CommonSpecComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.client.renderer.armor.StoneMaskRenderer;
import net.arna.jcraft.common.network.s2c.StoneMaskClenchPacket;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneMaskItem
extends ArmorItem
implements GeoItem {
    private static final int CLENCH_DURATION = 100;
    private static final Int2IntMap CLENCH = new Int2IntOpenHashMap();
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public StoneMaskItem(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public static void clench(LivingEntity entity) {
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        if (Platform.getEnv() == Dist.CLIENT) {
            CLENCH.put(entity.m_19879_(), 100);
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            level.m_245747_(entity.m_20183_(), (SoundEvent)JSoundRegistry.VAMPIRE_SPEC_CHANGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f, true);
        } else {
            StoneMaskClenchPacket.sendStoneMaskClench((ServerPlayer)entity);
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        CommonSpecComponent specComponent;
        ServerPlayer player;
        super.m_6883_(stack, world, entity, slot, selected);
        if (slot != EquipmentSlot.HEAD.m_20749_()) {
            return;
        }
        if (entity instanceof ServerPlayer && JCraft.wasRecentlyAttacked((player = (ServerPlayer)entity).m_21231_()) && (specComponent = JComponentPlatformUtils.getSpecData((LivingEntity)player)).getType() != JSpecTypeRegistry.VAMPIRE.get()) {
            specComponent.setType((SpecType)JSpecTypeRegistry.VAMPIRE.get());
            StoneMaskItem.clench((LivingEntity)player);
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, List<Component> tooltip, @NotNull TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)"jcraft.stonemask.desc"));
        super.m_7373_(stack, world, tooltip, context);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<StoneMaskItem> state) {
        Entity entity = (Entity)state.getData(DataTickets.ENTITY);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            RawAnimation anim = CLENCH.containsKey(livingEntity.m_19879_()) ? RawAnimation.begin().thenPlayAndHold("animation.stone_mask.clench") : RawAnimation.begin().thenLoop("animation.stone_mask.dormant");
            state.getController().setAnimation(anim);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private static GeoArmorRenderer<?> renderer;

            @NonNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
                if (renderer == null) {
                    renderer = new StoneMaskRenderer();
                }
                renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    static {
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientTickEvent.CLIENT_POST.register(client -> {
                IntOpenHashSet toRemove = new IntOpenHashSet();
                IntIterator intIterator = CLENCH.keySet().iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    int newTime = CLENCH.get(i) - 1;
                    if (newTime <= 0) {
                        toRemove.add(i);
                        continue;
                    }
                    CLENCH.put(i, newTime);
                }
                toRemove.forEach(arg_0 -> ((Int2IntMap)CLENCH).remove(arg_0));
            });
        }
    }
}

