/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.item;

import lombok.NonNull;
import net.arna.jcraft.common.entity.vehicle.AbstractGroundVehicleEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class VehicleItem<T extends AbstractGroundVehicleEntity>
extends Item {
    public static final int PLACEMENT_COOLDOWN = 10;
    private final VehicleCreator<T> creator;

    public VehicleItem(Item.Properties properties, VehicleCreator<T> creator) {
        super(properties);
        this.creator = creator;
    }

    public boolean create(@NonNull Level level, @Nullable Player owner, @NonNull Vec3 position, @NonNull ItemStack itemStack) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (level.f_46443_) {
            return false;
        }
        boolean hasOwner = owner != null;
        AbstractGroundVehicleEntity vehicle = (AbstractGroundVehicleEntity)((Object)this.creator.create(level, (Entity)owner));
        vehicle.m_146884_(position);
        if (hasOwner) {
            vehicle.m_146926_(owner.m_146909_());
        }
        if (level.m_7967_((Entity)vehicle)) {
            if (hasOwner) {
                owner.m_36335_().m_41524_((Item)this, 10);
                itemStack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.create(context.m_43725_(), context.m_43723_(), context.m_43720_(), context.m_43722_()) ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        return this.create(level, player, player.m_20182_(), itemStack) ? InteractionResultHolder.m_19096_((Object)itemStack) : InteractionResultHolder.m_19098_((Object)itemStack);
    }

    @FunctionalInterface
    public static interface VehicleCreator<T> {
        public T create(Level var1, Entity var2);
    }
}

