/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.loot;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.function.Consumer;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.common.enchantments.CinderellasKissEnchantment;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class JLootTableHelper {
    public static final Multimap<ResourceLocation, Consumer<LootTable.Builder>> modifications = MultimapBuilder.hashKeys().linkedHashSetValues().build();

    public static void registerLootTables() {
        JLootTableHelper.registerModification(JLootTableHelper::addMaskPool, new ResourceLocation("chests/abandoned_mineshaft"), new ResourceLocation("chests/buried_treasure"), new ResourceLocation("chests/end_city_treasure"), new ResourceLocation("chests/pillager_outpost"), new ResourceLocation("chests/simple_dungeon"), new ResourceLocation("chests/spawn_bonus_chest"), new ResourceLocation("chests/stronghold_library"), new ResourceLocation("chests/woodland_mansion"));
    }

    public static void registerModification(Consumer<LootTable.Builder> modifier, ResourceLocation ... lootTables) {
        for (ResourceLocation lootTable : lootTables) {
            modifications.put((Object)lootTable, modifier);
        }
    }

    private static void addMaskPool(LootTable.Builder builder) {
        builder.m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)JItemRegistry.CINDERELLA_MASK.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_((Enchantment)CinderellasKissEnchantment.INSTANCE, (NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.4f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(2).m_79078_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_((Enchantment)CinderellasKissEnchantment.INSTANCE, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder(true).m_165374_((Enchantment)CinderellasKissEnchantment.INSTANCE, (NumberProvider)BinomialDistributionGenerator.m_165659_((int)2, (float)0.25f)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.08f)));
        builder.m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)JItemRegistry.STONE_MASK.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.04f)));
    }
}

