/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.marker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import net.arna.jcraft.api.attack.moves.BlockMarkerMove;
import net.arna.jcraft.api.stand.StandEntity;

public final class BlockMarkerMoves {
    private static boolean iterating = false;
    private static final Multimap<StandEntity<?, ?>, BlockMarkerMove> ADD_QUEUE = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private static final Queue<StandEntity<?, ?>> REMOVE_QUEUE = new LinkedBlockingQueue();
    private static final Multimap<StandEntity<?, ?>, BlockMarkerMove> MOVES = HashMultimap.create();

    public static void mergeQueues() {
        MOVES.putAll(ADD_QUEUE);
        ADD_QUEUE.clear();
        for (StandEntity standEntity : REMOVE_QUEUE) {
            MOVES.removeAll((Object)standEntity);
        }
        REMOVE_QUEUE.clear();
    }

    public static void forEach(Consumer<BlockMarkerMove> consumer) {
        iterating = true;
        MOVES.forEach((T stand, U move) -> consumer.accept((BlockMarkerMove)move));
        iterating = false;
    }

    public static void add(StandEntity<?, ?> stand, BlockMarkerMove move) {
        if (!MOVES.containsEntry(stand, (Object)move) && !ADD_QUEUE.containsEntry(stand, (Object)move)) {
            if (iterating) {
                ADD_QUEUE.put(stand, (Object)move);
            } else {
                MOVES.put(stand, (Object)move);
            }
        }
    }

    public static void remove(StandEntity<?, ?> stand) {
        if (iterating) {
            REMOVE_QUEUE.add(stand);
        } else {
            MOVES.removeAll(stand);
        }
    }

    private BlockMarkerMoves() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

