/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.marker;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import lombok.NonNull;
import net.arna.jcraft.common.marker.EntityDataHandler;
import net.arna.jcraft.common.marker.EntityMarker;
import net.arna.jcraft.common.marker.MarkerLoadPredicate;
import net.arna.jcraft.common.marker.MarkerSavePredicate;
import net.arna.jcraft.common.marker.MarkerType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class EntityMarkerType
implements MarkerSavePredicate<UUID, Entity>,
MarkerLoadPredicate<EntityMarker>,
MarkerType<UUID, Entity, EntityMarker> {
    @NonNull
    protected final MarkerSavePredicate<UUID, Entity> savePredicate;
    @NonNull
    protected final MarkerLoadPredicate<EntityMarker> loadPredicate;
    @NonNull
    protected final Set<ResourceLocation> ids = new HashSet<ResourceLocation>();
    @NonNull
    protected final EntityDataHandler dataHandler;

    public EntityMarkerType(@NonNull Predicate<Entity> savePredicate, @NonNull MarkerLoadPredicate<EntityMarker> loadPredicate, @NonNull Collection<ResourceLocation> ids, @NonNull EntityDataHandler dataHandler) {
        this((UUID id, Entity entity) -> savePredicate.test((Entity)entity), loadPredicate, ids, dataHandler);
        if (savePredicate == null) {
            throw new NullPointerException("savePredicate is marked non-null but is null");
        }
        if (loadPredicate == null) {
            throw new NullPointerException("loadPredicate is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (dataHandler == null) {
            throw new NullPointerException("dataHandler is marked non-null but is null");
        }
    }

    public EntityMarkerType(@NonNull MarkerSavePredicate<UUID, Entity> savePredicate, @NonNull MarkerLoadPredicate<EntityMarker> loadPredicate, @NonNull Collection<ResourceLocation> ids, @NonNull EntityDataHandler dataHandler) {
        if (savePredicate == null) {
            throw new NullPointerException("savePredicate is marked non-null but is null");
        }
        if (loadPredicate == null) {
            throw new NullPointerException("loadPredicate is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (dataHandler == null) {
            throw new NullPointerException("dataHandler is marked non-null but is null");
        }
        this.savePredicate = savePredicate;
        this.loadPredicate = loadPredicate;
        this.ids.addAll(ids);
        this.dataHandler = dataHandler;
    }

    public Set<ResourceLocation> getIds() {
        return Collections.unmodifiableSet(this.ids);
    }

    @Override
    public boolean shouldSave(@NonNull UUID id, @NonNull Entity object) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return this.savePredicate.shouldSave(id, object);
    }

    @Override
    public boolean shouldLoad(@NonNull EntityMarker marker, @NonNull ServerLevel level) {
        if (marker == null) {
            throw new NullPointerException("marker is marked non-null but is null");
        }
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        return this.loadPredicate.shouldLoad(marker, level);
    }

    @Override
    @NotNull
    public EntityMarker save(@NonNull UUID id, @NonNull Entity object) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        CompoundTag compoundTag = new CompoundTag();
        for (ResourceLocation loc : this.ids) {
            if (!this.dataHandler.predicate().test(loc, object)) continue;
            this.dataHandler.extractor().accept(loc, object, compoundTag);
        }
        return new EntityMarker(id, compoundTag);
    }

    @Override
    @NonNull
    public Optional<Pair<UUID, Entity>> load(@NonNull EntityMarker marker, @NonNull ServerLevel level) {
        if (marker == null) {
            throw new NullPointerException("marker is marked non-null but is null");
        }
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        CompoundTag compoundTag = marker.state();
        Entity entity = level.m_8791_(marker.id());
        if (entity == null) {
            return Optional.empty();
        }
        for (ResourceLocation loc : this.ids) {
            if (!this.dataHandler.predicate().test(loc, entity)) continue;
            this.dataHandler.injector().accept(loc, entity, compoundTag);
        }
        return Optional.of(Pair.of((Object)marker.id(), (Object)entity));
    }

    @NonNull
    public EntityMarkerType and(@NonNull MarkerSavePredicate<UUID, Entity> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return new EntityMarkerType(this.savePredicate.and(other), this.loadPredicate, this.ids, this.dataHandler);
    }

    @NonNull
    public EntityMarkerType or(@NonNull MarkerSavePredicate<UUID, Entity> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return new EntityMarkerType(this.savePredicate.or(other), this.loadPredicate, this.ids, this.dataHandler);
    }

    @NonNull
    public EntityMarkerType negateSave() {
        return new EntityMarkerType(this.savePredicate.negateSave(), this.loadPredicate, this.ids, this.dataHandler);
    }

    @NonNull
    public MarkerSavePredicate<UUID, Entity> getSavePredicate() {
        return this.savePredicate;
    }

    @NonNull
    public MarkerLoadPredicate<EntityMarker> getLoadPredicate() {
        return this.loadPredicate;
    }

    @NonNull
    public EntityDataHandler getDataHandler() {
        return this.dataHandler;
    }
}

