/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.marker;

import net.arna.jcraft.api.component.living.CommonVampireComponent;
import net.arna.jcraft.common.marker.Identifiers;
import net.arna.jcraft.common.util.NbtUtils;
import net.arna.jcraft.common.util.TriConsumer;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface Extractors {
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> ENTITY = (id, entity, compoundTag) -> {
        if (id == null) {
            return;
        }
        if (id.equals((Object)Identifiers.POSITION)) {
            Entity vehicle = entity.m_20202_();
            if (vehicle != null) {
                NbtUtils.put(compoundTag, Identifiers.POSITION.toString(), new Vec3(vehicle.m_20185_(), vehicle.m_20186_(), vehicle.m_20189_()));
            } else {
                NbtUtils.put(compoundTag, Identifiers.POSITION.toString(), new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
            }
        } else if (id.equals((Object)Identifiers.VELOCITY)) {
            NbtUtils.put(compoundTag, Identifiers.VELOCITY.toString(), entity.m_20184_());
        } else if (id.equals((Object)Identifiers.PITCH)) {
            compoundTag.m_128350_(Identifiers.PITCH.toString(), entity.m_146909_());
        } else if (id.equals((Object)Identifiers.YAW)) {
            compoundTag.m_128350_(Identifiers.YAW.toString(), entity.m_146908_());
        } else if (id.equals((Object)Identifiers.YAW_HEAD)) {
            compoundTag.m_128350_(Identifiers.YAW_HEAD.toString(), entity.m_6080_());
        } else if (id.equals((Object)Identifiers.FALL_DISTANCE)) {
            compoundTag.m_128350_(Identifiers.FALL_DISTANCE.toString(), entity.f_19789_);
        } else if (id.equals((Object)Identifiers.FIRE)) {
            compoundTag.m_128405_(Identifiers.FIRE.toString(), entity.m_20094_());
        } else if (id.equals((Object)Identifiers.AIR)) {
            compoundTag.m_128405_(Identifiers.AIR.toString(), entity.m_20146_());
        } else if (id.equals((Object)Identifiers.GROUNDED)) {
            compoundTag.m_128379_(Identifiers.GROUNDED.toString(), entity.m_20096_());
        } else if (id.equals((Object)Identifiers.INVULNERABLE)) {
            compoundTag.m_128379_(Identifiers.INVULNERABLE.toString(), entity.m_20147_());
        } else if (id.equals((Object)Identifiers.PORTAL_COOLDOWN)) {
            compoundTag.m_128405_(Identifiers.PORTAL_COOLDOWN.toString(), entity.m_287157_());
        } else if (id.equals((Object)Identifiers.UUID)) {
            compoundTag.m_128362_(Identifiers.UUID.toString(), entity.m_20148_());
        } else if (id.equals((Object)Identifiers.CUSTOM_NAME)) {
            Component component = entity.m_7770_();
            if (component != null) {
                compoundTag.m_128359_(Identifiers.CUSTOM_NAME.toString(), Component.Serializer.m_130703_((Component)component));
            }
        } else if (id.equals((Object)Identifiers.CUSTOM_NAME_VISIBLE)) {
            compoundTag.m_128379_(Identifiers.CUSTOM_NAME_VISIBLE.toString(), entity.m_20151_());
        } else if (id.equals((Object)Identifiers.SILENT)) {
            compoundTag.m_128379_(Identifiers.SILENT.toString(), entity.m_20067_());
        } else if (id.equals((Object)Identifiers.NO_GRAVITY)) {
            compoundTag.m_128379_(Identifiers.NO_GRAVITY.toString(), entity.m_20068_());
        } else if (id.equals((Object)Identifiers.GLOWING)) {
            compoundTag.m_128379_(Identifiers.GLOWING.toString(), entity.m_146886_());
        } else if (id.equals((Object)Identifiers.TICKS_FROZEN)) {
            compoundTag.m_128405_(Identifiers.TICKS_FROZEN.toString(), entity.m_146888_());
        } else if (id.equals((Object)Identifiers.TAGS)) {
            ListTag listTag = new ListTag();
            for (String string : entity.m_19880_()) {
                listTag.add((Object)StringTag.m_129297_((String)string));
            }
            compoundTag.m_128365_(Identifiers.TAGS.toString(), (Tag)listTag);
        } else if (id.equals((Object)Identifiers.VEHICLE) && entity.m_20202_() != null) {
            compoundTag.m_128362_(Identifiers.VEHICLE.toString(), entity.m_20202_().m_20148_());
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> LIVING_ENTITY = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (id.equals((Object)Identifiers.HEALTH)) {
            compoundTag.m_128350_(Identifiers.HEALTH.toString(), livingEntity.m_21223_());
        } else if (id.equals((Object)Identifiers.HURT_TIME)) {
            compoundTag.m_128405_(Identifiers.HURT_TIME.toString(), livingEntity.f_20916_);
        } else if (id.equals((Object)Identifiers.DEATH_TIME)) {
            compoundTag.m_128405_(Identifiers.DEATH_TIME.toString(), livingEntity.f_20919_);
        } else if (id.equals((Object)Identifiers.ABSORPTION_AMOUNT)) {
            compoundTag.m_128350_(Identifiers.ABSORPTION_AMOUNT.toString(), livingEntity.m_6103_());
        } else if (id.equals((Object)Identifiers.ATTRIBUTES)) {
            compoundTag.m_128365_(Identifiers.ATTRIBUTES.toString(), (Tag)livingEntity.m_21204_().m_22180_());
        } else if (id.equals((Object)Identifiers.ACTIVE_EFFECTS)) {
            ListTag listTag = new ListTag();
            for (MobEffectInstance mobEffectInstance : livingEntity.m_21220_()) {
                listTag.add((Object)mobEffectInstance.m_19555_(new CompoundTag()));
            }
            compoundTag.m_128365_(Identifiers.ACTIVE_EFFECTS.toString(), (Tag)listTag);
        } else if (id.equals((Object)Identifiers.SLEEPING_POSITION) && livingEntity.m_21257_().isPresent()) {
            NbtUtils.put(compoundTag, Identifiers.SLEEPING_POSITION.toString(), (Vec3i)livingEntity.m_21257_().get());
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> PLAYER = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (id.equals((Object)Identifiers.INVENTORY)) {
            compoundTag.m_128365_(Identifiers.INVENTORY.toString(), (Tag)player.m_150109_().m_36026_(new ListTag()));
        } else if (id.equals((Object)Identifiers.SELECTED_ITEM_SLOT)) {
            compoundTag.m_128405_(Identifiers.SELECTED_ITEM_SLOT.toString(), player.m_150109_().f_35977_);
        } else if (id.equals((Object)Identifiers.XP_PROGRESS)) {
            compoundTag.m_128350_(Identifiers.XP_PROGRESS.toString(), player.f_36080_);
        } else if (id.equals((Object)Identifiers.XP_LEVEL)) {
            compoundTag.m_128405_(Identifiers.XP_LEVEL.toString(), player.f_36078_);
        } else if (id.equals((Object)Identifiers.XP_TOTAL)) {
            compoundTag.m_128405_(Identifiers.XP_TOTAL.toString(), player.f_36079_);
        } else if (id.equals((Object)Identifiers.SCORE)) {
            compoundTag.m_128405_(Identifiers.SCORE.toString(), player.m_36344_());
        } else if (id.equals((Object)Identifiers.FOOD_DATA)) {
            player.m_36324_().m_38719_(compoundTag);
        } else if (id.equals((Object)Identifiers.PLAYER_ABILITIES)) {
            player.m_150110_().m_35945_(compoundTag);
        } else if (id.equals((Object)Identifiers.ENDER_CHEST)) {
            compoundTag.m_128365_(Identifiers.ENDER_CHEST.toString(), (Tag)player.m_36327_().m_7927_());
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> MOB = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (id.equals((Object)Identifiers.CAN_PICKUP_LOOT)) {
            compoundTag.m_128379_(Identifiers.CAN_PICKUP_LOOT.toString(), mob.m_21531_());
        } else if (id.equals((Object)Identifiers.PERSISTENCE_REQUIRED)) {
            compoundTag.m_128379_(Identifiers.PERSISTENCE_REQUIRED.toString(), mob.m_21532_());
        } else if (id.equals((Object)Identifiers.LEFT_HANDED_MOB)) {
            compoundTag.m_128379_(Identifiers.LEFT_HANDED_MOB.toString(), mob.m_21526_());
        } else if (id.equals((Object)Identifiers.NO_AI)) {
            compoundTag.m_128379_(Identifiers.NO_AI.toString(), mob.m_21526_());
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> AGEABLE_MOB = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof AgeableMob)) {
            return;
        }
        AgeableMob ageableMob = (AgeableMob)entity;
        if (id.equals((Object)Identifiers.AGE)) {
            compoundTag.m_128405_(Identifiers.AGE.toString(), ageableMob.m_146764_());
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> VAMPIRE = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        CommonVampireComponent vampire = JComponentPlatformUtils.getVampirism(livingEntity);
        if (vampire != null && vampire.isVampire() && id.equals((Object)Identifiers.BLOOD_GAUGE)) {
            compoundTag.m_128350_(Identifiers.BLOOD_GAUGE.toString(), vampire.getBlood());
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> ALL = (id, entity, compoundTag) -> {
        ENTITY.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        LIVING_ENTITY.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        PLAYER.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        MOB.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        AGEABLE_MOB.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        VAMPIRE.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
    };
}

