/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.marker;

import java.util.EnumSet;
import java.util.UUID;
import net.arna.jcraft.api.component.living.CommonVampireComponent;
import net.arna.jcraft.common.marker.Identifiers;
import net.arna.jcraft.common.util.NbtUtils;
import net.arna.jcraft.common.util.TriConsumer;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public interface Injectors {
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> ENTITY = (id, entity, compoundTag) -> {
        block61: {
            block60: {
                if (id == null) {
                    return;
                }
                if (!id.equals((Object)Identifiers.POSITION) || !compoundTag.m_128441_(Identifiers.POSITION.toString()) || !compoundTag.m_128441_(Identifiers.PITCH.toString()) || !compoundTag.m_128441_(Identifiers.YAW.toString()) || !compoundTag.m_128441_(Identifiers.YAW_HEAD.toString())) break block60;
                Vec3 pos = NbtUtils.getVec3(compoundTag, Identifiers.POSITION.toString());
                float pitch = compoundTag.m_128457_(Identifiers.PITCH.toString());
                float yaw = compoundTag.m_128457_(Identifiers.YAW.toString());
                float yawHead = compoundTag.m_128457_(Identifiers.YAW_HEAD.toString());
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    serverPlayer.m_264318_(serverPlayer.m_284548_(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), EnumSet.noneOf(RelativeMovement.class), yaw, pitch);
                    serverPlayer.m_5616_(yawHead);
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundRotateHeadPacket((Entity)serverPlayer, (byte)(yaw * 256.0f / 360.0f)));
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)serverPlayer));
                } else {
                    entity.m_6021_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                    entity.m_146922_(yaw);
                    entity.m_146926_(pitch);
                    entity.m_5616_(yawHead);
                    entity.m_5618_(yaw);
                    entity.f_19859_ = yaw;
                    entity.f_19860_ = pitch;
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        livingEntity.f_20886_ = yawHead;
                        livingEntity.f_20884_ = yaw;
                    }
                }
                if (!compoundTag.m_128441_(Identifiers.VEHICLE.toString())) break block61;
                UUID vehicleUuid = compoundTag.m_128342_(Identifiers.VEHICLE.toString());
                Entity vehicle = ((ServerLevel)entity.m_9236_()).m_8791_(vehicleUuid);
                if (vehicle == null) break block61;
                entity.m_20329_(vehicle);
                break block61;
            }
            if (id.equals((Object)Identifiers.VELOCITY)) {
                if (compoundTag.m_128441_(Identifiers.VELOCITY.toString())) {
                    entity.m_20256_(NbtUtils.getVec3(compoundTag, Identifiers.VELOCITY.toString()));
                } else {
                    entity.m_20334_(0.0, 0.0, 0.0);
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
            } else if (id.equals((Object)Identifiers.FALL_DISTANCE)) {
                entity.f_19789_ = compoundTag.m_128441_(Identifiers.FALL_DISTANCE.toString()) ? compoundTag.m_128457_(Identifiers.FALL_DISTANCE.toString()) : 0.0f;
            } else if (id.equals((Object)Identifiers.FIRE)) {
                if (compoundTag.m_128441_(Identifiers.FIRE.toString())) {
                    entity.m_7311_(compoundTag.m_128451_(Identifiers.FIRE.toString()));
                } else {
                    entity.m_7311_(0);
                }
            } else if (id.equals((Object)Identifiers.AIR)) {
                if (compoundTag.m_128441_(Identifiers.AIR.toString())) {
                    entity.m_20301_(compoundTag.m_128451_(Identifiers.AIR.toString()));
                } else {
                    entity.m_20301_(20);
                }
            } else if (id.equals((Object)Identifiers.GROUNDED)) {
                if (compoundTag.m_128441_(Identifiers.GROUNDED.toString())) {
                    entity.m_6853_(compoundTag.m_128471_(Identifiers.GROUNDED.toString()));
                } else {
                    entity.m_6853_(true);
                }
            } else if (id.equals((Object)Identifiers.INVULNERABLE)) {
                if (compoundTag.m_128441_(Identifiers.INVULNERABLE.toString())) {
                    entity.m_20331_(compoundTag.m_128471_(Identifiers.INVULNERABLE.toString()));
                } else {
                    entity.m_6853_(true);
                }
            } else if (id.equals((Object)Identifiers.PORTAL_COOLDOWN)) {
                if (compoundTag.m_128441_(Identifiers.PORTAL_COOLDOWN.toString())) {
                    entity.m_287199_(compoundTag.m_128451_(Identifiers.PORTAL_COOLDOWN.toString()));
                } else {
                    entity.m_287199_(0);
                }
            } else if (id.equals((Object)Identifiers.UUID) && compoundTag.m_128441_(Identifiers.UUID.toString())) {
                entity.m_20084_(compoundTag.m_128342_(Identifiers.UUID.toString()));
            } else if (id.equals((Object)Identifiers.CUSTOM_NAME)) {
                String name = compoundTag.m_128461_(Identifiers.CUSTOM_NAME.toString());
                if (name.isEmpty()) {
                    entity.m_6593_(null);
                } else {
                    entity.m_6593_((Component)Component.Serializer.m_130701_((String)name));
                }
            } else if (id.equals((Object)Identifiers.CUSTOM_NAME_VISIBLE)) {
                if (compoundTag.m_128441_(Identifiers.CUSTOM_NAME_VISIBLE.toString())) {
                    entity.m_20340_(compoundTag.m_128471_(Identifiers.CUSTOM_NAME_VISIBLE.toString()));
                } else {
                    entity.m_20340_(true);
                }
            } else if (id.equals((Object)Identifiers.SILENT)) {
                if (compoundTag.m_128441_(Identifiers.SILENT.toString())) {
                    entity.m_20225_(compoundTag.m_128471_(Identifiers.SILENT.toString()));
                } else {
                    entity.m_20225_(false);
                }
            } else if (id.equals((Object)Identifiers.NO_GRAVITY)) {
                if (compoundTag.m_128441_(Identifiers.NO_GRAVITY.toString())) {
                    entity.m_20242_(compoundTag.m_128471_(Identifiers.NO_GRAVITY.toString()));
                } else {
                    entity.m_20242_(false);
                }
            } else if (id.equals((Object)Identifiers.GLOWING)) {
                if (compoundTag.m_128441_(Identifiers.GLOWING.toString())) {
                    entity.m_146915_(compoundTag.m_128471_(Identifiers.GLOWING.toString()));
                } else {
                    entity.m_146915_(false);
                }
            } else if (id.equals((Object)Identifiers.TICKS_FROZEN)) {
                if (compoundTag.m_128441_(Identifiers.TICKS_FROZEN.toString())) {
                    entity.m_146917_(compoundTag.m_128451_(Identifiers.TICKS_FROZEN.toString()));
                } else {
                    entity.m_146917_(0);
                }
            } else if (id.equals((Object)Identifiers.TAGS)) {
                entity.m_19880_().clear();
                if (compoundTag.m_128425_(Identifiers.TAGS.toString(), 9)) {
                    ListTag list = compoundTag.m_128437_(Identifiers.TAGS.toString(), 8);
                    for (int i = 0; i < list.size(); ++i) {
                        entity.m_19880_().add(list.m_128778_(i));
                    }
                }
            }
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> LIVING_ENTITY = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (id.equals((Object)Identifiers.HEALTH)) {
            if (compoundTag.m_128441_(Identifiers.HEALTH.toString())) {
                livingEntity.m_21153_(compoundTag.m_128457_(Identifiers.HEALTH.toString()));
            } else {
                livingEntity.m_21153_(livingEntity.m_21233_());
            }
        } else if (id.equals((Object)Identifiers.HURT_TIME) && compoundTag.m_128441_(Identifiers.HURT_TIME.toString())) {
            livingEntity.f_20916_ = compoundTag.m_128451_(Identifiers.HURT_TIME.toString());
        } else if (id.equals((Object)Identifiers.DEATH_TIME) && compoundTag.m_128441_(Identifiers.DEATH_TIME.toString())) {
            livingEntity.f_20919_ = compoundTag.m_128451_(Identifiers.DEATH_TIME.toString());
        } else if (id.equals((Object)Identifiers.ABSORPTION_AMOUNT)) {
            if (compoundTag.m_128441_(Identifiers.ABSORPTION_AMOUNT.toString())) {
                livingEntity.m_7911_(compoundTag.m_128457_(Identifiers.ABSORPTION_AMOUNT.toString()));
            } else {
                livingEntity.m_7911_(0.0f);
            }
        } else if (id.equals((Object)Identifiers.ATTRIBUTES) && compoundTag.m_128425_(Identifiers.ATTRIBUTES.toString(), 9)) {
            livingEntity.m_21204_().m_22168_(compoundTag.m_128437_(Identifiers.ATTRIBUTES.toString(), 10));
        } else if (id.equals((Object)Identifiers.ACTIVE_EFFECTS)) {
            livingEntity.m_21221_().clear();
            if (compoundTag.m_128441_(Identifiers.ACTIVE_EFFECTS.toString())) {
                ListTag list = compoundTag.m_128437_(Identifiers.ACTIVE_EFFECTS.toString(), 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.m_128728_(i);
                    MobEffectInstance mobEffectInstance = MobEffectInstance.m_19560_((CompoundTag)tag);
                    if (mobEffectInstance == null) continue;
                    livingEntity.m_21221_().put(mobEffectInstance.m_19544_(), mobEffectInstance);
                }
            }
        } else if (id.equals((Object)Identifiers.SLEEPING_POSITION) && compoundTag.m_128441_(Identifiers.SLEEPING_POSITION.toString())) {
            livingEntity.m_21250_(new BlockPos(NbtUtils.getVec3i(compoundTag, Identifiers.SLEEPING_POSITION.toString())));
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> PLAYER = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (id.equals((Object)Identifiers.INVENTORY)) {
            player.m_150109_().m_6211_();
            if (compoundTag.m_128441_(Identifiers.INVENTORY.toString())) {
                player.m_150109_().m_36035_(compoundTag.m_128437_(Identifiers.INVENTORY.toString(), 10));
            }
        } else if (id.equals((Object)Identifiers.SELECTED_ITEM_SLOT)) {
            player.m_150109_().f_35977_ = compoundTag.m_128441_(Identifiers.SELECTED_ITEM_SLOT.toString()) ? compoundTag.m_128451_(Identifiers.SELECTED_ITEM_SLOT.toString()) : 0;
        } else if (id.equals((Object)Identifiers.XP_PROGRESS)) {
            player.f_36080_ = compoundTag.m_128441_(Identifiers.XP_PROGRESS.toString()) ? compoundTag.m_128457_(Identifiers.XP_PROGRESS.toString()) : 0.0f;
        } else if (id.equals((Object)Identifiers.XP_LEVEL)) {
            player.f_36078_ = compoundTag.m_128441_(Identifiers.XP_LEVEL.toString()) ? compoundTag.m_128451_(Identifiers.XP_LEVEL.toString()) : 0;
        } else if (id.equals((Object)Identifiers.XP_TOTAL)) {
            player.f_36079_ = compoundTag.m_128441_(Identifiers.XP_TOTAL.toString()) ? compoundTag.m_128451_(Identifiers.XP_TOTAL.toString()) : 0;
        } else if (id.equals((Object)Identifiers.SCORE)) {
            if (compoundTag.m_128441_(Identifiers.SCORE.toString())) {
                player.m_36397_(compoundTag.m_128451_(Identifiers.SCORE.toString()));
            } else {
                player.m_36397_(0);
            }
        } else if (id.equals((Object)Identifiers.FOOD_DATA)) {
            player.m_36324_().m_38715_(compoundTag);
        } else if (id.equals((Object)Identifiers.PLAYER_ABILITIES)) {
            player.m_150110_().m_35950_(compoundTag);
        } else if (id.equals((Object)Identifiers.ENDER_CHEST)) {
            player.m_36327_().m_7797_(compoundTag.m_128437_(Identifiers.ENDER_CHEST.toString(), 10));
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> MOB = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (id.equals((Object)Identifiers.CAN_PICKUP_LOOT)) {
            if (compoundTag.m_128441_(Identifiers.CAN_PICKUP_LOOT.toString())) {
                mob.m_21553_(compoundTag.m_128471_(Identifiers.CAN_PICKUP_LOOT.toString()));
            } else {
                mob.m_21553_(false);
            }
        } else if (id.equals((Object)Identifiers.PERSISTENCE_REQUIRED)) {
            if (compoundTag.m_128441_(Identifiers.PERSISTENCE_REQUIRED.toString()) && compoundTag.m_128471_(Identifiers.PERSISTENCE_REQUIRED.toString())) {
                mob.m_21530_();
            }
        } else if (id.equals((Object)Identifiers.LEFT_HANDED_MOB) && compoundTag.m_128441_(Identifiers.LEFT_HANDED_MOB.toString())) {
            mob.m_21559_(compoundTag.m_128471_(Identifiers.LEFT_HANDED_MOB.toString()));
        } else if (id.equals((Object)Identifiers.NO_AI)) {
            if (compoundTag.m_128441_(Identifiers.NO_AI.toString())) {
                mob.m_21557_(compoundTag.m_128471_(Identifiers.NO_AI.toString()));
            } else {
                mob.m_21557_(false);
            }
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> AGABLE_MOB = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof AgeableMob)) {
            return;
        }
        AgeableMob ageableMob = (AgeableMob)entity;
        if (id.equals((Object)Identifiers.AGE)) {
            if (compoundTag.m_128441_(Identifiers.AGE.toString())) {
                ageableMob.m_146762_(compoundTag.m_128451_(Identifiers.AGE.toString()));
            } else {
                ageableMob.m_146762_(0);
            }
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> VAMPIRE = (id, entity, compoundTag) -> {
        if (id == null || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        CommonVampireComponent vampire = JComponentPlatformUtils.getVampirism(livingEntity);
        if (vampire != null && vampire.isVampire() && id.equals((Object)Identifiers.BLOOD_GAUGE)) {
            if (compoundTag.m_128441_(Identifiers.BLOOD_GAUGE.toString())) {
                vampire.setBlood(compoundTag.m_128457_(Identifiers.BLOOD_GAUGE.toString()));
            } else {
                vampire.setBlood(20.0f);
            }
        }
    };
    public static final TriConsumer<ResourceLocation, Entity, CompoundTag> ALL = (id, entity, compoundTag) -> {
        ENTITY.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        LIVING_ENTITY.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        PLAYER.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        MOB.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        AGABLE_MOB.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
        VAMPIRE.accept((ResourceLocation)id, (Entity)entity, (CompoundTag)compoundTag);
    };
}

