/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.marker;

import lombok.NonNull;
import net.arna.jcraft.common.marker.Marker;
import net.minecraft.server.level.ServerLevel;

@FunctionalInterface
public interface MarkerLoadPredicate<M extends Marker<?, ?>> {
    public boolean shouldLoad(@NonNull M var1, @NonNull ServerLevel var2);

    @NonNull
    default public MarkerLoadPredicate<M> and(@NonNull MarkerLoadPredicate<M> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return (marker, level) -> this.shouldLoad(marker, level) && other.shouldLoad(marker, level);
    }

    @NonNull
    default public MarkerLoadPredicate<M> or(@NonNull MarkerLoadPredicate<M> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return (marker, level) -> this.shouldLoad(marker, level) || other.shouldLoad(marker, level);
    }

    @NonNull
    default public MarkerLoadPredicate<M> negateLoad() {
        return (marker, level) -> !this.shouldLoad(marker, level);
    }
}

