/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.minigame;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import net.arna.jcraft.common.minigame.Wager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractWager {
    private static final Comparator<ItemStack> STACK_COMPARATOR = Comparator.comparing(ItemStack::m_41613_).reversed();
    private static final Comparator<ItemStack> ITEM_COMPARATOR = Comparator.comparing(stack -> stack.m_41611_().getString());
    protected static final Comparator<ItemStack> ITEM_STACK_COMPARATOR = ITEM_COMPARATOR.thenComparing(STACK_COMPARATOR);
    protected final List<ItemStack> items = new LinkedList<ItemStack>();

    protected AbstractWager() {
    }

    public boolean expands(@NonNull AbstractWager wager) {
        if (wager == null) {
            throw new NullPointerException("wager is marked non-null but is null");
        }
        if (wager.items.size() > this.items.size()) {
            return false;
        }
        Iterator<ItemStack> smallerIt = wager.items.iterator();
        Iterator<ItemStack> biggerIt = this.items.iterator();
        while (smallerIt.hasNext()) {
            if (ItemStack.m_150942_((ItemStack)smallerIt.next(), (ItemStack)biggerIt.next())) continue;
            return false;
        }
        return true;
    }

    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        ListTag itemsTag = new ListTag();
        for (ItemStack stack : this.items) {
            CompoundTag itemNbt = new CompoundTag();
            stack.m_41739_(itemNbt);
            itemsTag.add((Object)itemNbt);
        }
        tag.m_128365_("wager_items", (Tag)itemsTag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Wager)) {
            return false;
        }
        Wager wager = (Wager)o;
        if (this.items.size() != wager.items.size()) {
            return false;
        }
        Iterator<ItemStack> it1 = this.items.iterator();
        Iterator it2 = wager.items.iterator();
        while (it1.hasNext()) {
            if (ItemStack.m_150942_((ItemStack)it1.next(), (ItemStack)((ItemStack)it2.next()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 43 + this.items.size();
        for (ItemStack stack : this.items) {
            hash = 43 * hash + stack.m_41613_() * stack.m_41720_().hashCode();
        }
        return Objects.hash(this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{items=").append(this.items);
        sb.append('}');
        return sb.toString();
    }
}

