/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.minigame;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import net.arna.jcraft.common.minigame.AbstractWager;
import net.arna.jcraft.common.minigame.ImmutableWager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class Wager
extends AbstractWager {
    public Wager() {
    }

    public Wager(@NonNull AbstractWager wager) {
        if (wager == null) {
            throw new NullPointerException("wager is marked non-null but is null");
        }
        for (ItemStack stack : wager.items) {
            this.items.add(stack.m_41777_());
        }
    }

    public void increaseWager(@NonNull ItemStack increase) {
        if (increase == null) {
            throw new NullPointerException("increase is marked non-null but is null");
        }
        this.items.add(Objects.requireNonNull(increase));
    }

    public void sort() {
        this.items.sort(ITEM_STACK_COMPARATOR);
    }

    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.items.clear();
        for (Tag itemTag : tag.m_128437_("wager_items", 10)) {
            this.items.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)itemTag)));
        }
    }

    public static Wager sum(@NonNull Collection<? extends AbstractWager> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        Wager result = new Wager();
        for (AbstractWager abstractWager : coll) {
            for (ItemStack stack : abstractWager.items) {
                result.increaseWager(stack);
            }
        }
        return result;
    }

    public static Wager sum(@NonNull AbstractWager wager1, @NonNull AbstractWager wager2) {
        if (wager1 == null) {
            throw new NullPointerException("wager1 is marked non-null but is null");
        }
        if (wager2 == null) {
            throw new NullPointerException("wager2 is marked non-null but is null");
        }
        return Wager.sum(List.of(wager1, wager2));
    }

    public static ImmutableWager split(@NonNull AbstractWager wager, int divisor) {
        if (wager == null) {
            throw new NullPointerException("wager is marked non-null but is null");
        }
        if (divisor <= 0) {
            throw new IllegalArgumentException("Divisor must be positive!");
        }
        if (divisor == 1) {
            return new ImmutableWager(wager);
        }
        Wager split = new Wager();
        for (ItemStack stack : wager.items) {
            split.increaseWager(stack.m_255036_(stack.m_41613_() / divisor));
        }
        return new ImmutableWager(split);
    }
}

