/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.minigame.card;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.arna.jcraft.common.minigame.card.Rank;
import net.arna.jcraft.common.minigame.card.Suit;

public record Card(Suit suit, Rank rank) {
    public Card(Suit suit, Rank rank) {
        this.suit = Objects.requireNonNull(suit);
        this.rank = Objects.requireNonNull(rank);
    }

    public int encode() {
        return this.suit.ordinal() * 13 + this.rank().ordinal();
    }

    public static Card decode(int value) {
        return new Card(Suit.values()[value / 13], Rank.values()[value % 13]);
    }

    public static List<Card> createPokerDeck() {
        ArrayList<Card> deck = new ArrayList<Card>(52);
        for (Suit suit : Suit.values()) {
            for (Rank rank : Rank.values()) {
                deck.add(new Card(suit, rank));
            }
        }
        return deck;
    }
}

