/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.minigame.card.texasholdem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.common.minigame.AbstractWager;
import net.arna.jcraft.common.minigame.ImmutableWager;
import net.arna.jcraft.common.minigame.Wager;
import net.arna.jcraft.common.minigame.card.Card;
import net.arna.jcraft.common.minigame.card.Rank;
import net.arna.jcraft.common.minigame.card.Suit;
import net.arna.jcraft.common.minigame.card.texasholdem.Phase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class Engine {
    public static final Comparator<Card> RANK_COMPARATOR = Rank.createComparator(true).reversed();
    public static final Comparator<Collection<Card>> HAND_COMPARATOR = (hand1, hand2) -> {
        HandEvaluator[] handEvaluators = HandEvaluator.values();
        for (int index = handEvaluators.length - 1; index >= 0; --index) {
            Optional<List<Rank>> hand1Val = handEvaluators[index].apply((Collection<Card>)hand1);
            Optional<List<Rank>> hand2Val = handEvaluators[index].apply((Collection<Card>)hand2);
            if (hand1Val.isEmpty() && hand2Val.isPresent()) {
                return 1;
            }
            if (hand1Val.isPresent() && hand2Val.isEmpty()) {
                return -1;
            }
            if (hand1Val.isEmpty()) continue;
            List<Rank> hand1ranks = hand1Val.get();
            List<Rank> hand2ranks = hand2Val.get();
            if (hand1ranks.size() != hand2ranks.size()) {
                JCraft.LOGGER.error(String.format("Hands %s and %s lead to differently sized results in evaluator %s!", hand1, hand2, handEvaluators[index].name()));
                return 0;
            }
            Iterator<Rank> hand1it = hand1ranks.iterator();
            Iterator<Rank> hand2it = hand2ranks.iterator();
            while (hand1it.hasNext()) {
                Rank current1 = hand1it.next();
                Rank current2 = hand2it.next();
                if (current1.pokerValue() < current2.pokerValue()) {
                    return 1;
                }
                if (current1.pokerValue() <= current2.pokerValue()) continue;
                return -1;
            }
            return 0;
        }
        JCraft.LOGGER.error(String.format("Hands %s and %s can't even be compared with HIGH_CARD!", hand1, hand2));
        return 0;
    };
    private final int playerCount;
    private final List<Wager> wagers;
    private final List<ImmutableWager> currentRaises;
    private final List<List<Card>> pockets;
    private Wager pot = new Wager();
    private boolean potChanged;
    private Phase phase = Phase.PRE_POCKET;
    private Integer bigBlindPlayer;
    private ImmutableWager bigBlind;
    private ImmutableWager currentRaise = ImmutableWager.EMPTY;
    private final List<Card> deck = Card.createPokerDeck();
    private final List<Card> burn = new ArrayList<Card>(3);
    private final List<Card> community = new ArrayList<Card>(5);

    public Engine(int playerCount) {
        if (playerCount < 2) {
            throw new IllegalArgumentException(String.format("At least 2 players are needed, %d is too few!", playerCount));
        }
        if (playerCount > 22) {
            throw new IllegalArgumentException(String.format("%d is too many players!", playerCount));
        }
        this.playerCount = playerCount;
        this.wagers = new ArrayList<Wager>(playerCount);
        this.resetPlayerWagers();
        this.pockets = new ArrayList<List<Card>>(playerCount);
        this.resetPockets();
        this.currentRaises = new ArrayList<ImmutableWager>(playerCount);
        this.resetPlayerCurrentRaises();
    }

    public int playerCount() {
        return this.playerCount;
    }

    public void resetPlayerWagers() {
        this.wagers.clear();
        for (int player = 0; player < this.playerCount; ++player) {
            this.wagers.add(new Wager());
        }
    }

    @NonNull
    public ImmutableWager getWager(int player) {
        return new ImmutableWager(this.wagers.get(player));
    }

    public void resetPlayerCurrentRaises() {
        this.currentRaises.clear();
        for (int player = 0; player < this.playerCount; ++player) {
            this.currentRaises.add(ImmutableWager.EMPTY);
        }
    }

    public void raise(int player, @NonNull ImmutableWager raise) {
        if (raise == null) {
            throw new NullPointerException("raise is marked non-null but is null");
        }
        if (!raise.expands(this.currentRaise)) {
            throw new IllegalArgumentException(String.format("%s is not an expansion of %s!", raise, this.currentRaise));
        }
        this.currentRaises.set(player, raise);
        this.currentRaise = raise;
        this.potChanged = true;
    }

    public void raiseCallFoldFinished() {
        for (int player = 0; player < this.playerCount; ++player) {
            this.wagers.set(player, Wager.sum(this.wagers.get(player), this.currentRaises.get(player)));
        }
        this.resetPlayerCurrentRaises();
    }

    public void resetPockets() {
        this.pockets.clear();
        for (int player = 0; player < this.playerCount; ++player) {
            this.pockets.add(new ArrayList(2));
        }
    }

    public void calculatePot() {
        this.pot = Wager.sum(Wager.sum(this.wagers), Wager.sum(this.currentRaises));
        this.pot.sort();
    }

    @NonNull
    public ImmutableWager getPot() {
        if (this.potChanged) {
            this.calculatePot();
            this.potChanged = false;
        }
        return new ImmutableWager(this.pot);
    }

    @NonNull
    public Optional<ImmutableWager> getBigBlind() {
        if (this.bigBlind == null) {
            return Optional.empty();
        }
        return Optional.of(this.bigBlind);
    }

    public boolean setBigBlind(int player, @NonNull AbstractWager bigBlind) {
        if (bigBlind == null) {
            throw new NullPointerException("bigBlind is marked non-null but is null");
        }
        if (this.bigBlind != null) {
            return false;
        }
        this.bigBlind = new ImmutableWager(bigBlind);
        this.bigBlindPlayer = player;
        this.raise(this.bigBlindPlayer, this.bigBlind);
        return true;
    }

    public void dealPockets() {
        if (this.bigBlindPlayer == null) {
            throw new IllegalStateException("Big Blind wasn't set!");
        }
        if (this.phase != Phase.PRE_POCKET) {
            throw new IllegalStateException("Wrong phase " + this.phase.name() + " to deal pockets!");
        }
        this.phase = Phase.POCKET;
        Collections.shuffle(this.deck);
        int smallBlindPlayer = this.bigBlindPlayer == 0 ? this.playerCount - 1 : this.bigBlindPlayer - 1;
        for (int i = 0; i < 2 * this.playerCount; ++i) {
            this.pockets.get((smallBlindPlayer + i) % this.playerCount).add(this.deck.remove(this.deck.size() - 1));
        }
        this.phase = Phase.PRE_FLOP;
    }

    public List<Card> viewCommunity() {
        return Collections.unmodifiableList(this.community);
    }

    public void dealFlop() {
        if (this.phase != Phase.PRE_FLOP) {
            throw new IllegalStateException("Wrong phase " + this.phase.name() + " to deal flop!");
        }
        this.phase = Phase.FLOP;
        this.burn.add(this.deck.remove(this.deck.size() - 1));
        for (int i = 0; i < 3; ++i) {
            this.community.add(this.deck.remove(this.deck.size() - 1));
        }
        this.phase = Phase.PRE_TURN;
    }

    public void dealTurn() {
        if (this.phase != Phase.PRE_TURN) {
            throw new IllegalStateException("Wrong phase " + this.phase.name() + " to deal turn!");
        }
        this.phase = Phase.TURN;
        this.burn.add(this.deck.remove(this.deck.size() - 1));
        this.community.add(this.deck.remove(this.deck.size() - 1));
        this.phase = Phase.PRE_RIVER;
    }

    public void dealRiver() {
        if (this.phase != Phase.PRE_RIVER) {
            throw new IllegalStateException("Wrong phase " + this.phase.name() + " to deal river!");
        }
        this.phase = Phase.RIVER;
        this.burn.add(this.deck.remove(this.deck.size() - 1));
        this.community.add(this.deck.remove(this.deck.size() - 1));
        this.phase = Phase.PRE_END;
    }

    public void readFromNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        ListIterator<Wager> wagersIt = this.wagers.listIterator();
        for (Object wagerTag : tag.m_128437_("wagers", 10)) {
            wagersIt.next().readFromNbt((CompoundTag)wagerTag);
        }
        ListIterator<ImmutableWager> currentRaisesIt = this.currentRaises.listIterator();
        for (Tag currentRaiseTag : tag.m_128437_("current_raises", 10)) {
            Wager currentRaise = new Wager();
            currentRaise.readFromNbt((CompoundTag)currentRaiseTag);
            currentRaisesIt.next();
            currentRaisesIt.set(new ImmutableWager(currentRaise));
        }
        this.potChanged = true;
        CompoundTag bigBlindTag = tag.m_128469_("big_blind");
        Wager bigBlind = new Wager();
        bigBlind.readFromNbt(bigBlindTag);
        this.bigBlind = new ImmutableWager(bigBlind);
        this.bigBlindPlayer = tag.m_128451_("big_blind_player");
        CompoundTag currentRaiseTag = tag.m_128469_("current_raise");
        Wager currentRaise = new Wager();
        currentRaise.readFromNbt(currentRaiseTag);
        this.currentRaise = new ImmutableWager(currentRaise);
        this.resetPockets();
        Iterator<List<Card>> pocketsIt = this.pockets.iterator();
        for (Tag pocketTag : tag.m_128437_("pockets", 9)) {
            List<Card> pocket = pocketsIt.next();
            for (Tag card : (ListTag)pocketTag) {
                pocket.add(Card.decode(((IntTag)card).m_7047_()));
            }
        }
        for (Tag burnCardTag : tag.m_128437_("burn", 3)) {
            this.burn.add(Card.decode(((IntTag)burnCardTag).m_7047_()));
        }
        for (Tag communityCardTag : tag.m_128437_("community", 3)) {
            this.community.add(Card.decode(((IntTag)communityCardTag).m_7047_()));
        }
        for (Tag deckCardTag : tag.m_128437_("deck", 3)) {
            this.deck.add(Card.decode(((IntTag)deckCardTag).m_7047_()));
        }
        this.phase = Phase.values()[tag.m_128451_("phase")];
    }

    public void writeToNbt(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        ListTag wagersTag = new ListTag();
        for (Wager wager : this.wagers) {
            CompoundTag wagerTag = new CompoundTag();
            wager.writeToNbt(wagerTag);
            wagersTag.add((Object)wagerTag);
        }
        tag.m_128365_("wagers", (Tag)wagersTag);
        ListTag currentRaisesTag = new ListTag();
        for (ImmutableWager currentRaise : this.currentRaises) {
            CompoundTag currentRaiseTag = new CompoundTag();
            currentRaise.writeToNbt(currentRaiseTag);
            currentRaisesTag.add((Object)currentRaiseTag);
        }
        tag.m_128365_("current_raises", (Tag)currentRaisesTag);
        CompoundTag compoundTag = new CompoundTag();
        this.bigBlind.writeToNbt(compoundTag);
        tag.m_128365_("big_blind", (Tag)compoundTag);
        tag.m_128365_("big_blind_player", (Tag)IntTag.m_128679_((int)this.bigBlindPlayer));
        CompoundTag currentRaiseTag = new CompoundTag();
        this.currentRaise.writeToNbt(currentRaiseTag);
        tag.m_128365_("current_raise", (Tag)currentRaiseTag);
        ListTag pocketsTag = new ListTag();
        for (List<Card> list : this.pockets) {
            ListTag listTag = new ListTag();
            for (Card card : list) {
                listTag.add((Object)IntTag.m_128679_((int)card.encode()));
            }
            pocketsTag.add((Object)listTag);
        }
        tag.m_128365_("pockets", (Tag)pocketsTag);
        ListTag burnTag = new ListTag();
        for (Card card : this.burn) {
            burnTag.add((Object)IntTag.m_128679_((int)card.encode()));
        }
        tag.m_128365_("burn", (Tag)burnTag);
        ListTag listTag = new ListTag();
        for (Card card : this.community) {
            listTag.add((Object)IntTag.m_128679_((int)card.encode()));
        }
        tag.m_128365_("community", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (Card card : this.deck) {
            listTag2.add((Object)IntTag.m_128679_((int)card.encode()));
        }
        tag.m_128365_("deck", (Tag)listTag2);
        tag.m_128365_("phase", (Tag)IntTag.m_128679_((int)this.phase.ordinal()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{playerCount=").append(this.playerCount);
        sb.append(", wagers=").append(this.wagers);
        sb.append(", currentRaises=").append(this.currentRaises);
        sb.append(", pockets=").append(this.pockets);
        sb.append(", pot=").append(this.pot);
        sb.append(", potChanged=").append(this.potChanged);
        sb.append(", phase=").append((Object)this.phase);
        sb.append(", bigBlindPlayer=").append(this.bigBlindPlayer);
        sb.append(", bigBlind=").append(this.bigBlind);
        sb.append(", currentRaise=").append(this.currentRaise);
        sb.append(", deck=").append(this.deck);
        sb.append(", burn=").append(this.burn);
        sb.append(", community=").append(this.community);
        sb.append('}');
        return sb.toString();
    }

    public Phase getPhase() {
        return this.phase;
    }

    public static enum HandEvaluator implements Function<Collection<Card>, Optional<List<Rank>>>
    {
        HIGH_CARD(cards -> Optional.of(cards.stream().sorted(RANK_COMPARATOR).limit(5L).map(Card::rank).toList())),
        PAIR(cards -> {
            ArrayList<Card> sorted = new ArrayList<Card>((Collection<Card>)cards);
            sorted.sort(RANK_COMPARATOR);
            LinkedList<Rank> ranks = new LinkedList<Rank>();
            Iterator it = sorted.iterator();
            Card latest = (Card)it.next();
            while (it.hasNext()) {
                Card current = (Card)it.next();
                if (latest.rank() == current.rank()) {
                    HandEvaluator.cards2Ranks(sorted, ranks);
                    ranks.remove((Object)latest.rank());
                    ranks.remove((Object)current.rank());
                    ranks.removeLast();
                    ranks.removeLast();
                    ranks.addFirst(current.rank());
                    break;
                }
                latest = current;
            }
            if (ranks.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(ranks);
        }),
        TWO_PAIRS(cards -> {
            Optional<List<Rank>> firstPair = HandEvaluator.PAIR.evaluator.apply((Collection<Card>)cards);
            if (firstPair.isEmpty()) {
                return Optional.empty();
            }
            List<Rank> ranks = null;
            Iterator<Rank> it = firstPair.get().iterator();
            Rank highestPair = it.next();
            Rank latest = it.next();
            while (it.hasNext()) {
                Rank current = it.next();
                if (latest == current) {
                    ranks = firstPair.get();
                    if (current == highestPair) {
                        ranks.remove((Object)current);
                        break;
                    }
                    ranks.remove((Object)latest);
                    ranks.remove((Object)current);
                    ranks.add(1, current);
                    break;
                }
                latest = current;
            }
            if (ranks == null) {
                ArrayList<Card> sorted = new ArrayList<Card>((Collection<Card>)cards);
                sorted.sort(RANK_COMPARATOR);
                if (((Card)sorted.get(4)).rank() == ((Card)sorted.get(5)).rank() || ((Card)sorted.get(5)).rank() == ((Card)sorted.get(6)).rank()) {
                    ranks = firstPair.get();
                    ranks.remove(3);
                    ranks.remove(2);
                    ranks.add(1, ((Card)sorted.get(5)).rank());
                }
            }
            return Optional.ofNullable(ranks);
        }),
        THREE_OF_A_KIND(cards -> {
            ArrayList<Card> sorted = new ArrayList<Card>((Collection<Card>)cards);
            sorted.sort(RANK_COMPARATOR);
            LinkedList<Rank> ranks = new LinkedList<Rank>();
            Iterator it = sorted.iterator();
            Card secondToLatest = (Card)it.next();
            Card latest = (Card)it.next();
            while (it.hasNext()) {
                Card current = (Card)it.next();
                if (secondToLatest.rank() == latest.rank() && latest.rank() == current.rank()) {
                    HandEvaluator.cards2Ranks(sorted, ranks);
                    ranks.remove((Object)secondToLatest.rank());
                    ranks.remove((Object)latest.rank());
                    ranks.remove((Object)current.rank());
                    ranks.removeLast();
                    ranks.removeLast();
                    ranks.addFirst(current.rank());
                    break;
                }
                secondToLatest = latest;
                latest = current;
            }
            if (ranks.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(ranks);
        }),
        STRAIGHT(cards -> {
            int highest;
            ArrayList<Card> sorted = new ArrayList<Card>((Collection<Card>)cards);
            sorted.sort(RANK_COMPARATOR);
            boolean[] ranks = new boolean[13];
            for (Card card : sorted) {
                ranks[card.rank().pokerValue() - 1] = true;
            }
            for (highest = ranks.length - 1; highest > 3; --highest) {
                boolean match = true;
                for (int i = 0; i < 5; ++i) {
                    match &= ranks[highest - i];
                }
                if (match) break;
            }
            if (highest <= 3) {
                return Optional.empty();
            }
            if (highest == 12) {
                return Optional.of(List.of(Rank.AS));
            }
            return Optional.of(List.of(Rank.values()[highest + 1]));
        }),
        FLUSH(cards -> {
            ArrayList<Card> sorted = new ArrayList<Card>((Collection<Card>)cards);
            sorted.sort(RANK_COMPARATOR);
            int[] counts = new int[4];
            for (Card card : sorted) {
                int n = card.suit().ordinal();
                counts[n] = counts[n] + 1;
            }
            LinkedList<Rank> ranks = null;
            block1: for (Suit suit : Suit.values()) {
                if (counts[suit.ordinal()] < 5) continue;
                ranks = new LinkedList<Rank>();
                for (Card card : sorted) {
                    if (card.suit() != suit) continue;
                    ranks.add(card.rank());
                    if (ranks.size() != 5) continue;
                    break block1;
                }
                break;
            }
            return Optional.ofNullable(ranks);
        }),
        FULL_HOUSE(cards -> {
            Optional<List<Rank>> threeOfAKind = HandEvaluator.THREE_OF_A_KIND.evaluator.apply((Collection<Card>)cards);
            if (threeOfAKind.isEmpty()) {
                return Optional.empty();
            }
            List<Rank> ranks = null;
            if (threeOfAKind.get().get(1) == threeOfAKind.get().get(2)) {
                ranks = threeOfAKind.get();
                ranks.remove(1);
            }
            if (ranks == null) {
                ArrayList<Card> sorted = new ArrayList<Card>((Collection<Card>)cards);
                sorted.sort(RANK_COMPARATOR);
                if (((Card)sorted.get(4)).rank() == ((Card)sorted.get(5)).rank() && ((Card)sorted.get(3)).rank() != ((Card)sorted.get(4)).rank() || ((Card)sorted.get(5)).rank() == ((Card)sorted.get(6)).rank()) {
                    ranks = threeOfAKind.get();
                    ranks.remove(2);
                    ranks.add(1, ((Card)sorted.get(5)).rank());
                }
            }
            return Optional.ofNullable(ranks);
        }),
        FOUR_OF_A_KIND(cards -> {
            ArrayList<Card> sorted = new ArrayList<Card>((Collection<Card>)cards);
            sorted.sort(RANK_COMPARATOR);
            Rank fourKind = ((Card)sorted.get(3)).rank();
            Rank highest = ((Card)sorted.get(0)).rank() == fourKind ? ((Card)sorted.get(4)).rank() : ((Card)sorted.get(0)).rank();
            int count = 0;
            for (Card card : sorted) {
                if (card.rank() != fourKind) continue;
                ++count;
            }
            if (count >= 4) {
                return Optional.of(List.of(fourKind, highest));
            }
            return Optional.empty();
        }),
        STRAIGHT_FLUSH(cards -> {
            int highest;
            ArrayList<Card> sorted = new ArrayList<Card>((Collection<Card>)cards);
            sorted.sort(RANK_COMPARATOR);
            boolean[] ranks = new boolean[13];
            for (Card card : sorted) {
                ranks[card.rank().pokerValue() - 1] = true;
            }
            block1: for (highest = ranks.length - 1; highest > 3; --highest) {
                boolean matchStraight = true;
                for (int i = 0; i < 5; ++i) {
                    matchStraight &= ranks[highest - i];
                }
                if (!matchStraight) continue;
                for (Suit suit : Suit.values()) {
                    boolean matchFlush = true;
                    for (int i = 0; i < 5; ++i) {
                        int rank;
                        int n = rank = highest == 12 && i == 0 ? 0 : highest - i + 1;
                        if (!(matchFlush &= sorted.contains(new Card(suit, Rank.values()[rank])))) break;
                    }
                    if (matchFlush) break block1;
                }
            }
            if (highest <= 3) {
                return Optional.empty();
            }
            if (highest == 12) {
                return Optional.of(List.of(Rank.AS));
            }
            return Optional.of(List.of(Rank.values()[highest + 1]));
        });

        private final Function<Collection<Card>, Optional<List<Rank>>> evaluator;

        private HandEvaluator(Function<Collection<Card>, Optional<List<Rank>>> evaluator) {
            this.evaluator = Objects.requireNonNull(evaluator);
        }

        private static void checkCollection(@NonNull Collection<Card> cards) {
            if (cards == null) {
                throw new NullPointerException("cards is marked non-null but is null");
            }
            if (cards.size() != 7) {
                throw new IllegalArgumentException("Can only evaluate a number of 7 cards!");
            }
        }

        private static void cards2Ranks(@NonNull List<Card> sorted, @NonNull List<Rank> empty) {
            if (sorted == null) {
                throw new NullPointerException("sorted is marked non-null but is null");
            }
            if (empty == null) {
                throw new NullPointerException("empty is marked non-null but is null");
            }
            for (Card card : sorted) {
                empty.add(card.rank());
            }
        }

        @Override
        public Optional<List<Rank>> apply(@NonNull Collection<Card> cards) {
            if (cards == null) {
                throw new NullPointerException("cards is marked non-null but is null");
            }
            HandEvaluator.checkCollection(cards);
            return this.evaluator.apply(cards);
        }
    }
}

