/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.minigame.card.texasholdem;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import net.arna.jcraft.common.minigame.card.texasholdem.Engine;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityLookup;

public final class TexasHoldEm {
    private static final EntityLookup<LivingEntity> ENTITY_LOOKUP = new EntityLookup();
    private final Set<LivingEntity> players;
    private final Set<String> playersUuid = new HashSet<String>();
    private Engine engine;

    public TexasHoldEm() {
        this.players = new HashSet<LivingEntity>();
    }

    public TexasHoldEm(@NonNull Set<LivingEntity> players) {
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        this.players = new HashSet<LivingEntity>(players);
        this.engine = new Engine(players.size());
        Level world = this.players.iterator().next().m_9236_();
        for (LivingEntity entity : this.players) {
            if (entity.m_9236_().equals(world)) continue;
            throw new IllegalStateException(String.format("All players must belong to the same world, but %s doesn't!", entity));
        }
        for (LivingEntity player : players) {
            this.playersUuid.add(player.m_20149_());
        }
    }

    public Set<String> getPlayersUuid() {
        return this.playersUuid;
    }

    public boolean reloadPlayers(@NonNull Level world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (!this.players.isEmpty()) {
            return false;
        }
        for (String playerUuid : this.playersUuid) {
            LivingEntity player = (LivingEntity)ENTITY_LOOKUP.m_156819_(UUID.fromString(playerUuid));
            if (player == null) {
                this.players.clear();
                return false;
            }
            this.players.add(player);
        }
        return true;
    }

    public void readFromNbt(CompoundTag tag) {
        this.players.clear();
        this.playersUuid.clear();
        for (Tag playerTag : tag.m_128437_("players", 8)) {
            this.playersUuid.add(((StringTag)playerTag).m_7916_());
        }
        CompoundTag engineTag = tag.m_128469_("game");
        this.engine = new Engine(this.playersUuid.size());
        this.engine.readFromNbt(engineTag);
    }

    public void writeToNbt(CompoundTag tag) {
        ListTag playersTag = new ListTag();
        for (LivingEntity player : this.players) {
            playersTag.add((Object)StringTag.m_129297_((String)player.m_20149_()));
        }
        tag.m_128365_("players", (Tag)playersTag);
        CompoundTag engineTag = new CompoundTag();
        this.engine.writeToNbt(engineTag);
        tag.m_128365_("game", (Tag)engineTag);
    }
}

