/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.network.c2s;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.common.config.ConfigOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ConfigUpdatePacket {
    public static final ResourceLocation ID = JCraft.id("config_update");

    public static void handle(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        MinecraftServer server = context.getPlayer().m_20194_();
        if (server == null) {
            return;
        }
        if (!player.m_20310_(2) && !server.m_129792_()) {
            JCraft.LOGGER.warn("Player {} sent a config update packet while not having permission to do so.", (Object)player.m_36316_().getName());
            player.f_8906_.m_9942_((Component)Component.m_237113_((String)"You do not have permission to update the JCraft server config."));
            return;
        }
        Set<ConfigOption> changedOptions = ConfigOption.readOptions(buf);
        JServerConfig.save(server);
        FriendlyByteBuf clientChangesBuf = ConfigUpdatePacket.writeClientChanges(changedOptions);
        Set receivers = JUtils.all(server).stream().filter(serverPlayer -> serverPlayer != player).collect(Collectors.toUnmodifiableSet());
        NetworkManager.sendToPlayers(receivers, (ResourceLocation)JPacketRegistry.S2C_SERVER_CONFIG, (FriendlyByteBuf)clientChangesBuf);
    }

    private static FriendlyByteBuf writeClientChanges(Collection<ConfigOption> options) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(false);
        buf.writeBoolean(false);
        ConfigOption.writeOptions(buf, options);
        return buf;
    }

    public static void sendOptionsToClient(ServerPlayer player, Collection<ConfigOption> options) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)JPacketRegistry.S2C_SERVER_CONFIG, (FriendlyByteBuf)ConfigUpdatePacket.writeClientChanges(options));
    }
}

