/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.network.c2s;

import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.vehicle.AbstractGroundVehicleEntity;
import net.arna.jcraft.common.events.JServerPlayerInputEvent;
import net.arna.jcraft.common.item.Peacemaker;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.DashData;
import net.arna.jcraft.common.util.IJInputStateManagerHolder;
import net.arna.jcraft.common.util.InputStateManager;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.MovementInputType;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PlayerInputPacket {
    private static final int HOLD_TIMEOUT_TICKS = 3;
    private static final Map<ServerPlayer, Object2BooleanMap<MoveInputType>> successMap = new WeakHashMap<ServerPlayer, Object2BooleanMap<MoveInputType>>();
    private static final int MOVEMENT_INPUT_TYPES = MovementInputType.values().length;

    public static FriendlyByteBuf write(Object2BooleanMap<MovementInputType> movementInput, Object2BooleanMap<MoveInputType> moveInput) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        PlayerInputPacket.writeInput(buf, movementInput);
        PlayerInputPacket.writeInput(buf, moveInput);
        return buf;
    }

    private static void writeInput(FriendlyByteBuf buf, @Nullable Object2BooleanMap<? extends Enum<?>> input) {
        if (input == null) {
            buf.m_130130_(0);
            return;
        }
        buf.m_130130_(input.size());
        for (Object2BooleanMap.Entry entry : input.object2BooleanEntrySet()) {
            buf.m_130068_((Enum)entry.getKey());
            buf.writeBoolean(entry.getBooleanValue());
        }
    }

    public static void handle(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        MinecraftServer server = context.getPlayer().m_20194_();
        InputStateManager sm = PlayerInputPacket.getInputStateManager(player);
        PlayerInputPacket.handleMovementInput(server, player, buf, sm);
        PlayerInputPacket.handleMoveInput(player, buf, sm);
    }

    public static void handleHold(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        MinecraftServer server = context.getPlayer().m_20194_();
        buf.m_130242_();
        int count = buf.m_130242_();
        if (count > 9) {
            player.f_8906_.m_9942_(Component.m_130674_((String)"Illegal input packet!"));
        }
        InputStateManager sm = PlayerInputPacket.getInputStateManager(player);
        for (int i = 0; i < count; ++i) {
            MoveInputType type = (MoveInputType)buf.m_130066_(MoveInputType.class);
            buf.readBoolean();
            if (!JUtils.canHoldMove(player, type)) continue;
            sm.heldInputs.put(type, 3);
        }
    }

    private static void handleMovementInput(MinecraftServer server, ServerPlayer player, FriendlyByteBuf buf, InputStateManager sm) {
        int count = buf.m_130242_();
        if (count > MOVEMENT_INPUT_TYPES) {
            player.f_8906_.m_9942_(Component.m_130674_((String)"Illegal input packet!"));
        }
        for (int i = 0; i < count; ++i) {
            MovementInputType type = (MovementInputType)buf.m_130066_(MovementInputType.class);
            boolean pressed = buf.readBoolean();
            switch (type) {
                case FORWARD: {
                    sm.forward = pressed;
                    break;
                }
                case BACKWARD: {
                    sm.backward = pressed;
                    break;
                }
                case LEFT: {
                    sm.left = pressed;
                    break;
                }
                case RIGHT: {
                    sm.right = pressed;
                }
            }
            if (type == MovementInputType.JUMP) {
                sm.jumping = pressed;
            }
            if (type == MovementInputType.CROUCH) {
                sm.sneaking = pressed;
            }
            if (type != MovementInputType.DASH) continue;
            sm.dashing = pressed;
            if (!pressed) continue;
            server.execute(() -> DashData.tryDash(sm.calcForward(), sm.calcSide(), (LivingEntity)player));
        }
        if (sm.jumping) {
            server.execute(() -> PlayerInputPacket.checkComboBreak(player));
        }
    }

    private static void handleMoveInput(ServerPlayer player, FriendlyByteBuf buf, InputStateManager sm) {
        int count = buf.m_130242_();
        if (count > 9) {
            player.f_8906_.m_9942_(Component.m_130674_((String)"Illegal input packet!"));
        }
        MinecraftServer server = Objects.requireNonNull(player.m_20194_());
        for (int i = 0; i < count; ++i) {
            MoveInputType type = (MoveInputType)buf.m_130066_(MoveInputType.class);
            boolean pressed = buf.readBoolean();
            if (JUtils.canHoldMove(player, type)) {
                if (pressed) {
                    sm.heldInputs.put(type, 3);
                } else {
                    sm.heldInputs.put(type, 0);
                }
            }
            if (pressed) {
                PlayerInputPacket.handleMoveInput(server, player, type).thenAccept(b -> {
                    successMap.computeIfAbsent(player, p -> new Object2BooleanOpenHashMap()).put((Object)type, b.booleanValue());
                    server.execute(() -> {
                        JSpec<?, ?> spec;
                        ((JServerPlayerInputEvent)JServerPlayerInputEvent.EVENT.invoker()).onPlayerInput(player, type, true, (boolean)b);
                        boolean success = b;
                        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
                        if (stand != null && stand.allowMoveHandling()) {
                            stand.onUserMoveInput(type, true, success);
                            success = false;
                        }
                        if ((spec = JUtils.getSpec((LivingEntity)player)) != null) {
                            spec.onUserMoveInput(type, true, success);
                        }
                    });
                });
                continue;
            }
            boolean b2 = successMap.computeIfAbsent(player, p -> new Object2BooleanOpenHashMap()).getOrDefault((Object)type, false);
            server.execute(() -> {
                JSpec<?, ?> spec;
                ((JServerPlayerInputEvent)JServerPlayerInputEvent.EVENT.invoker()).onPlayerInput(player, type, false, b2);
                boolean success = b2;
                StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
                if (stand != null && stand.allowMoveHandling()) {
                    stand.onUserMoveInput(type, false, success);
                    success = false;
                }
                if ((spec = JUtils.getSpec((LivingEntity)player)) != null) {
                    spec.onUserMoveInput(type, false, success);
                }
            });
        }
    }

    private static CompletableFuture<Boolean> handleMoveInput(MinecraftServer server, ServerPlayer player, MoveInputType type) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ServerLevel world = (ServerLevel)player.m_9236_();
        server.execute(() -> {
            switch (type) {
                case STAND_SUMMON: {
                    FriendlyByteBuf buf2 = new FriendlyByteBuf(Unpooled.buffer());
                    buf2.writeShort(6);
                    buf2.writeInt(0);
                    ServerChannelFeedbackPacket.send(player, buf2);
                    CommonStandComponent standData = JComponentPlatformUtils.getStandComponent((LivingEntity)player);
                    StandEntity<?, ?> stand = standData.getStand();
                    if (stand != null) {
                        int moveStun = stand.getMoveStun();
                        if (moveStun > 0 && moveStun < 7) {
                            stand.queueMove(MoveInputType.STAND_SUMMON);
                            future.complete(false);
                            break;
                        }
                        stand.desummon();
                        future.complete(true);
                        break;
                    }
                    if (world == null) break;
                    JCraft.summon((Level)world, (LivingEntity)player);
                    future.complete(true);
                    break;
                }
                case LIGHT: {
                    boolean peacemakerHandled = Peacemaker.handleLeftClick((Player)player);
                    if (peacemakerHandled) {
                        future.complete(true);
                        return;
                    }
                    StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
                    if (stand == null || !stand.allowMoveHandling()) {
                        future.complete(false);
                        return;
                    }
                    future.complete(PlayerInputPacket.initStandMove(stand, MoveInputType.LIGHT));
                    break;
                }
                case UTILITY: {
                    StandEntity<?, ?> stand2;
                    StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
                    boolean s = stand != null ? PlayerInputPacket.initStandMove(stand, MoveInputType.UTILITY) : ((stand2 = JCraft.summon((Level)world, (LivingEntity)player)) != null && !stand2.wantToBlock ? stand2.initMove(MoveClass.UTILITY) : false);
                    future.complete(s);
                    break;
                }
                default: {
                    future.complete(PlayerInputPacket.initStandOrSpecMove(player, type));
                }
            }
        });
        return future;
    }

    private static boolean initStandOrSpecMove(ServerPlayer player, MoveInputType type) {
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
        if (stand != null && stand.allowMoveHandling()) {
            return PlayerInputPacket.initStandMove(stand, type);
        }
        JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)player);
        if (spec == null) {
            return false;
        }
        if (spec.initMove(type.getMoveClass())) {
            return true;
        }
        if (spec.moveStun > 0 && spec.moveStun < 11) {
            spec.queuedMove = type;
        }
        return false;
    }

    private static boolean initStandMove(StandEntity<?, ?> stand, MoveInputType type) {
        if (!stand.blocking) {
            int moveStun = stand.getMoveStun();
            if (stand.initMove(type.getMoveClass(stand.isStandby()))) {
                return true;
            }
            if (moveStun > 0 && moveStun < 7) {
                stand.queueMove(type);
            }
        }
        return false;
    }

    private static void checkComboBreak(ServerPlayer player) {
        InputStateManager sm = PlayerInputPacket.getInputStateManager(player);
        boolean blocking = JUtils.isBlocking((LivingEntity)player);
        if (sm == null || !sm.jumping || !player.m_6144_()) {
            return;
        }
        if (blocking) {
            StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
            if (stand == null) {
                JCraft.LOGGER.warn("Player " + String.valueOf(player) + " was blocking despite having no stand?");
            } else {
                if (stand.getMoveStun() < 2) {
                    return;
                }
                JCraft.tryPushBlock((ServerLevel)player.m_9236_(), (LivingEntity)player, stand);
            }
        } else {
            MobEffectInstance stun = player.m_21124_((MobEffect)JStatusRegistry.DAZED.get());
            if (stun != null) {
                JCraft.comboBreak((ServerLevel)player.m_9236_(), (LivingEntity)player, stun);
            }
        }
    }

    public static InputStateManager getInputStateManager(ServerPlayer player) {
        return ((IJInputStateManagerHolder)player).jcraft$getJInputStateManager();
    }

    static {
        TickEvent.SERVER_PRE.register(instance -> {
            for (ServerPlayer player : instance.m_6846_().m_11314_()) {
                Entity patt0$temp;
                InputStateManager sm = PlayerInputPacket.getInputStateManager(player);
                if (!sm.heldInputs.isEmpty()) {
                    sm.heldInputs.forEach((type, integer) -> {
                        if (integer == 0) {
                            sm.heldInputs.remove(type);
                            JSpec<?, ?> spec = JUtils.getSpec((LivingEntity)player);
                            if (spec != null) {
                                spec.onUserMoveInput((MoveInputType)((Object)((Object)type)), false, false);
                            }
                        } else {
                            Integer newValue = integer - 1;
                            if (newValue <= 0 || !JUtils.canHoldMove(player, type)) {
                                instance.execute(() -> {
                                    JSpec<?, ?> spec;
                                    boolean success = true;
                                    ((JServerPlayerInputEvent)JServerPlayerInputEvent.EVENT.invoker()).onPlayerInput(player, (MoveInputType)((Object)((Object)type)), false, success);
                                    StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
                                    if (stand != null && stand.allowMoveHandling()) {
                                        stand.onUserMoveInput((MoveInputType)((Object)((Object)type)), false, success);
                                        success = false;
                                    }
                                    if ((spec = JUtils.getSpec((LivingEntity)player)) != null) {
                                        spec.onUserMoveInput((MoveInputType)((Object)((Object)type)), false, success);
                                    }
                                });
                                sm.heldInputs.remove(type);
                            } else {
                                sm.heldInputs.put(type, newValue);
                            }
                        }
                    });
                    sm.heldInputs.keySet().forEach(type -> PlayerInputPacket.handleMoveInput(instance, player, type));
                }
                int forward = sm.calcForward();
                int side = sm.calcSide();
                JComponentPlatformUtils.getMiscData((LivingEntity)player).updateRemoteInputs(forward, side, sm.jumping);
                StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
                if (stand != null) {
                    stand.updateRemoteInputs(forward, side, sm.jumping, sm.sneaking);
                }
                if ((patt0$temp = player.m_20202_()) instanceof AbstractGroundVehicleEntity) {
                    AbstractGroundVehicleEntity groundVehicle = (AbstractGroundVehicleEntity)patt0$temp;
                    groundVehicle.updateInputs(forward, side, sm.jumping, sm.sneaking);
                }
                if (sm.dashing) {
                    DashData.tryDash(forward, side, (LivingEntity)player);
                }
                if (!sm.jumping) continue;
                if (DashData.isDashing((LivingEntity)player)) {
                    JComponentPlatformUtils.getCooldowns((LivingEntity)player).setCooldown(CooldownType.DASH, 100);
                }
                PlayerInputPacket.checkComboBreak(player);
            }
        });
    }
}

