/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.network.c2s;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.util.DashData;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class StandBlockPacket {
    private static final Set<ServerPlayer> blocking = Collections.newSetFromMap(new WeakHashMap());

    public static FriendlyByteBuf write(boolean isBlocking) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(isBlocking);
        return buf;
    }

    public static void handle(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        MinecraftServer server = context.getPlayer().m_20194_();
        boolean blockDown = buf.readBoolean();
        server.execute(() -> {
            if (blockDown) {
                blocking.add(player);
            } else {
                blocking.remove(player);
            }
            StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
            if (stand == null) {
                return;
            }
            boolean blocking = stand.wantToBlock;
            if (!blocking && blockDown) {
                if (StandBlockPacket.allowBlockingWith(player.m_21205_()) && StandBlockPacket.allowBlockingWith(player.m_21206_())) {
                    stand.wantToBlock = true;
                    if (stand.canAttack() && !DashData.isDashing((LivingEntity)player)) {
                        stand.tryBlock();
                    }
                }
            } else if (blocking && !blockDown) {
                stand.wantToBlock = false;
            }
        });
    }

    private static boolean allowBlockingWith(ItemStack itemStack) {
        if (itemStack.m_150930_((Item)JItemRegistry.ANUBIS.get()) || itemStack.m_150930_((Item)JItemRegistry.ANUBIS_SHEATHED.get())) {
            return true;
        }
        return itemStack.m_41780_() == UseAnim.NONE;
    }

    public static boolean isBlocking(ServerPlayer player) {
        return blocking.contains(player);
    }
}

