/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.network.s2c;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import lombok.NonNull;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerAnimPacket {
    public static void sendSpec(@NonNull Player from, @NonNull Iterable<ServerPlayer> to, String animID, int moveStun, float animationSpeed) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(from.m_19879_());
        buf.m_130070_(animID);
        buf.writeBoolean(true);
        buf.writeInt(moveStun);
        buf.writeFloat(animationSpeed);
        NetworkManager.sendToPlayers(to, (ResourceLocation)JPacketRegistry.S2C_PLAYER_ANIMATION, (FriendlyByteBuf)buf);
    }

    public static void send(Player from, ServerPlayer to, String animID) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(from.m_19879_());
        buf.m_130070_(animID);
        buf.writeBoolean(false);
        NetworkManager.sendToPlayer((ServerPlayer)to, (ResourceLocation)JPacketRegistry.S2C_PLAYER_ANIMATION, (FriendlyByteBuf)buf);
    }
}

