/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.network.s2c;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import lombok.NonNull;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.common.entity.stand.MadeInHeavenEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;

public class TimeAccelStatePacket {
    private static final Int2ObjectMap<TimeAcceleration> accelerations = new Int2ObjectOpenHashMap();
    private static final Object lock = new Object();
    private static final WeakHashMap<Level, Long> startDayTime = new WeakHashMap();

    public static void init() {
        TickEvent.SERVER_POST.register(TimeAccelStatePacket::tick);
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientTickEvent.CLIENT_POST.register(c -> {
                if (!c.m_91091_()) {
                    TimeAccelStatePacket.tick(c);
                }
            });
        }
        TickEvent.SERVER_LEVEL_POST.register(world -> {
            if (!world.m_46469_().m_46207_(GameRules.f_46140_)) {
                return;
            }
            TimeAccelStatePacket.applyAcceleration((Level)world, arg_0 -> ((ServerLevel)world).m_8615_(arg_0));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAcceleration(int mihEntityId, int duration, long startTime) {
        Object object = lock;
        synchronized (object) {
            accelerations.put(mihEntityId, (Object)new TimeAcceleration(duration, mihEntityId, startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAcceleration(int mihEntityId) {
        Object object = lock;
        synchronized (object) {
            accelerations.remove(mihEntityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendStart(@NonNull MadeInHeavenEntity mih, int duration) {
        if (mih == null) {
            throw new NullPointerException("mih is marked non-null but is null");
        }
        long time = System.currentTimeMillis();
        if (Objects.requireNonNull(mih.getEntityWorld().m_7654_()).m_6982_()) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130068_((Enum)State.START);
            buf.m_130130_(mih.m_19879_());
            buf.m_130130_(duration);
            buf.writeLong(time);
            NetworkManager.sendToPlayers((Iterable)((ServerLevel)mih.m_9236_()).m_6907_(), (ResourceLocation)JPacketRegistry.S2C_TIME_ACCELERATION_STATE, (FriendlyByteBuf)buf);
        }
        Object object = lock;
        synchronized (object) {
            accelerations.put(mih.m_19879_(), (Object)new TimeAcceleration(duration, mih.m_19879_(), time));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendStop(@NonNull MadeInHeavenEntity mih) {
        if (mih == null) {
            throw new NullPointerException("mih is marked non-null but is null");
        }
        if (Objects.requireNonNull(mih.m_20194_()).m_6982_()) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130068_((Enum)State.STOP);
            buf.m_130130_(mih.m_19879_());
            NetworkManager.sendToPlayers((Iterable)((ServerLevel)mih.m_9236_()).m_6907_(), (ResourceLocation)JPacketRegistry.S2C_TIME_ACCELERATION_STATE, (FriendlyByteBuf)buf);
        }
        Object object = lock;
        synchronized (object) {
            accelerations.remove(mih.m_19879_());
        }
    }

    private static double someBsArnaPutTogetherInDesmos(double x) {
        return Math.sqrt(1.0 - Math.pow(2.0 * x * x - 1.0, 2.0));
    }

    private static double integralOfSomeBsArnaPutTogetherInDesmos(double x) {
        double x2 = x * x;
        return (x2 - 1.0) * Math.sqrt(1.0 - x2) + 1.0;
    }

    public static void applyAcceleration(Level world, Consumer<Long> dayTimeSetter) {
        if (accelerations.isEmpty()) {
            startDayTime.put(world, -1L);
            return;
        }
        long start = startDayTime.getOrDefault(world, -1L);
        if (start < 0L) {
            start = world.m_46468_();
            startDayTime.put(world, start);
        }
        long total = accelerations.values().stream().filter(ta -> ta.isValid(world)).mapToLong(ta -> (long)Mth.m_14139_((double)TimeAccelStatePacket.integralOfSomeBsArnaPutTogetherInDesmos(Math.min(1.0, (double)(System.currentTimeMillis() - ta.getStartTime()) / ((double)ta.getInitialDuration() * 50.0))), (double)0.0, (double)240000.0)).sum();
        dayTimeSetter.accept(start + total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tick(Object o) {
        Object object = lock;
        synchronized (object) {
            if (accelerations.isEmpty()) {
                return;
            }
            boolean done = accelerations.values().stream().allMatch(ta -> {
                if (ta.getDuration() > 0) {
                    ta.decrementDuration();
                }
                return ta.getDuration() <= 0;
            });
            if (done) {
                accelerations.clear();
            }
        }
    }

    public static class TimeAcceleration {
        private int duration;
        private double lastAcceleration;
        private final int initialDuration;
        private final long startTime;
        private final int entityId;

        public TimeAcceleration(int duration, int entityId, long startTime) {
            this.duration = this.initialDuration = duration;
            this.entityId = entityId;
            this.startTime = startTime;
        }

        public boolean isValid(Level world) {
            return world.m_6815_(this.entityId) instanceof MadeInHeavenEntity;
        }

        public void decrementDuration() {
            --this.duration;
        }

        public int getDuration() {
            return this.duration;
        }

        public double getLastAcceleration() {
            return this.lastAcceleration;
        }

        public int getInitialDuration() {
            return this.initialDuration;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getEntityId() {
            return this.entityId;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }

        public void setLastAcceleration(double lastAcceleration) {
            this.lastAcceleration = lastAcceleration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimeAcceleration)) {
                return false;
            }
            TimeAcceleration other = (TimeAcceleration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            if (Double.compare(this.getLastAcceleration(), other.getLastAcceleration()) != 0) {
                return false;
            }
            if (this.getInitialDuration() != other.getInitialDuration()) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            return this.getEntityId() == other.getEntityId();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TimeAcceleration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDuration();
            long $lastAcceleration = Double.doubleToLongBits(this.getLastAcceleration());
            result = result * 59 + (int)($lastAcceleration >>> 32 ^ $lastAcceleration);
            result = result * 59 + this.getInitialDuration();
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            result = result * 59 + this.getEntityId();
            return result;
        }

        public String toString() {
            return "TimeAccelStatePacket.TimeAcceleration(duration=" + this.getDuration() + ", lastAcceleration=" + this.getLastAcceleration() + ", initialDuration=" + this.getInitialDuration() + ", startTime=" + this.getStartTime() + ", entityId=" + this.getEntityId() + ")";
        }
    }

    public static enum State {
        START,
        STOP;

    }
}

