/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.network.s2c;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TimeStopStatePacket {
    public static FriendlyByteBuf createStartPacket(int timestopperId, Vec3 position, ResourceKey<Level> worldRegistryKey, int duration) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(true);
        buf.writeInt(timestopperId);
        buf.writeDouble(position.f_82479_);
        buf.writeDouble(position.f_82480_);
        buf.writeDouble(position.f_82481_);
        buf.m_236858_(worldRegistryKey);
        buf.writeInt(duration);
        return buf;
    }

    public static FriendlyByteBuf createStopPacket(int timestopperId) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(false);
        buf.writeInt(timestopperId);
        return buf;
    }

    public static void send(ServerPlayer serverPlayerEntity, FriendlyByteBuf buf) {
        NetworkManager.sendToPlayer((ServerPlayer)serverPlayerEntity, (ResourceLocation)JPacketRegistry.S2C_TIME_STOP, (FriendlyByteBuf)buf);
    }

    public static void send(Iterable<ServerPlayer> serverPlayers, FriendlyByteBuf buf) {
        NetworkManager.sendToPlayers(serverPlayers, (ResourceLocation)JPacketRegistry.S2C_TIME_STOP, (FriendlyByteBuf)buf);
    }
}

