/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.saveddata;

import com.google.common.base.MoreObjects;
import dev.architectury.registry.registries.RegistrySupplier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.TreeSet;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.mixin.LevelStorageAccessAccessor;
import net.arna.jcraft.mixin.MinecraftServerAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExclusiveStandsData
extends SavedData {
    public static final Path DEFAULT_FILE_LOCATION = new File("data", "jcraft_usedStands.dat").toPath();
    private static final CompoundTag NO_STANDS = new CompoundTag();
    private static final String KEYWORD = "used";
    private final Set<ResourceLocation> usedStands = new TreeSet<ResourceLocation>();

    public ExclusiveStandsData(@NotNull CompoundTag compoundTag) {
        Tag tag = compoundTag.m_128423_(KEYWORD);
        if (tag == null) {
            return;
        }
        if (tag.m_6458_() == IntArrayTag.f_128599_) {
            for (IntTag i : (IntArrayTag)tag) {
                this.usedStands.add(((RegistrySupplier)JStandTypeRegistry.LEGACY_ORDINALS.get(i.m_7047_())).getId());
            }
        } else {
            this.usedStands.addAll(((ListTag)tag).stream().map(Tag::m_7916_).map(ResourceLocation::new).toList());
        }
    }

    public boolean isStandUsed(StandType standType) {
        return JServerConfig.EXCLUSIVE_STANDS.getValue() && this.usedStands.contains(standType.getId());
    }

    public boolean switchStand(@Nullable StandType prev, @Nullable StandType curr) {
        if (!JServerConfig.EXCLUSIVE_STANDS.getValue()) {
            return true;
        }
        if (this.isStandUsed(curr)) {
            return false;
        }
        if (prev != null) {
            this.usedStands.remove(prev.getId());
        }
        if (curr != null) {
            this.usedStands.add(curr.getId());
        }
        this.m_77762_();
        return true;
    }

    public static File getDefaultFileLocation(MinecraftServer server) {
        return ((LevelStorageAccessAccessor)((MinecraftServerAccessor)server).getStorageSource()).getLevelDirectory().f_230850_().resolve(DEFAULT_FILE_LOCATION).toFile();
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag tag = new ListTag();
        tag.addAll(this.usedStands.stream().map(ResourceLocation::toString).map(StringTag::m_129297_).toList());
        compoundTag.m_128365_(KEYWORD, (Tag)tag);
        return compoundTag;
    }

    public void saveToDefaultFile(MinecraftServer server) {
        this.m_77757_(ExclusiveStandsData.getDefaultFileLocation(server));
    }

    public static ExclusiveStandsData fromFile(File file) {
        CompoundTag compoundTag = null;
        try {
            CompoundTag fileData = NbtIo.m_128953_((File)file);
            if (fileData != null) {
                compoundTag = (CompoundTag)fileData.m_128423_("data");
            }
        }
        catch (IOException | ClassCastException | NullPointerException exception) {
            // empty catch block
        }
        return new ExclusiveStandsData((CompoundTag)MoreObjects.firstNonNull(compoundTag, (Object)NO_STANDS));
    }

    public static ExclusiveStandsData fromDefaultFile(MinecraftServer server) {
        return ExclusiveStandsData.fromFile(ExclusiveStandsData.getDefaultFileLocation(server));
    }
}

