/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.spec;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Set;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.SpecData;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.common.attack.moves.anubis.LowKickAttack;
import net.arna.jcraft.common.attack.moves.anubis.Rekka3Attack;
import net.arna.jcraft.common.attack.moves.anubis.SimpleAnubisAttack;
import net.arna.jcraft.common.attack.moves.anubis.SimpleAnubisMultiHitAttack;
import net.arna.jcraft.common.attack.moves.anubis.UnsheathingAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownMultiHitAttack;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.SpecAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnubisSpec
extends JSpec<AnubisSpec, State> {
    public static final MoveSet<AnubisSpec, State> MOVE_SET = MoveSetManager.create(JSpecTypeRegistry.ANUBIS, AnubisSpec::registerMoves, State.class);
    public static final SpecData DATA = SpecData.builder().name((Component)Component.m_237115_((String)"spec.jcraft.anubis")).description((Component)Component.m_237113_((String)"Accelerating offense")).details((Component)Component.m_237113_((String)"PASSIVE: Bloodlust\nLanding blows on opponents speeds up Anubis' attacks up to 2x, with +0.2x per hit.\nNot hitting opponents reduces Bloodlust by one stack every 4 seconds.")).build();
    public static final SimpleAnubisAttack AERIAL_CLEAVE = (SimpleAnubisAttack)((SimpleAnubisAttack)((SimpleAnubisAttack)((SimpleAnubisAttack)new SimpleAnubisAttack(0, 9, 15, 1.0f, 5.0f, 15, 1.75f, 0.4f, 0.3f, true, true).withSound(JSoundRegistry.ANUBIS_SLASH)).withImpactSound(SoundEvents.f_12317_)).withHitSpark(JParticleType.SWEEP_ATTACK)).withInfo((Component)Component.m_237113_((String)"Aerial Cleave"), (Component)Component.m_237113_((String)"interruptible faster recovery"));
    public static final SimpleAnubisAttack SLASH = (SimpleAnubisAttack)((SimpleAnubisAttack)((SimpleAnubisAttack)((SimpleAnubisAttack)((SimpleAnubisAttack)((SimpleAnubisAttack)new SimpleAnubisAttack(20, 9, 20, 1.0f, 6.0f, 15, 1.75f, 0.9f, 0.0f, true, true).withAerialVariant(AERIAL_CLEAVE)).withSound(JSoundRegistry.ANUBIS_SLASH)).withImpactSound(SoundEvents.f_12317_)).withHitSpark(JParticleType.SWEEP_ATTACK)).withHyperArmor()).withInfo((Component)Component.m_237113_((String)"Slash"), (Component)Component.m_237113_((String)"uninterruptible get-off-me tool"));
    public static final SimpleAnubisAttack POMMEL = (SimpleAnubisAttack)((SimpleAnubisAttack)((SimpleAnubisAttack)new SimpleAnubisAttack(20, 5, 8, 1.0f, 4.0f, 7, 1.25f, 0.2f, 0.0f, false, true).withSound(JSoundRegistry.ANUBIS_POMMEL)).withImpactSound(JSoundRegistry.IMPACT_3)).withInfo((Component)Component.m_237113_((String)"Pommel Strike"), (Component)Component.m_237113_((String)"fast jab"));
    public static final SimpleAnubisMultiHitAttack REKKA2 = (SimpleAnubisMultiHitAttack)((SimpleAnubisMultiHitAttack)((SimpleAnubisMultiHitAttack)new SimpleAnubisMultiHitAttack(10, 26, 1.0f, 4.0f, 15, 1.75f, 0.2f, -0.1f, (IntCollection)IntSet.of((int)8, (int)20), false).withSound(JSoundRegistry.ANUBIS_REKKA2)).withImpactSound(JSoundRegistry.IMPACT_4)).withInfo((Component)Component.m_237113_((String)"Cleaving Strikes (2 Hits)"), (Component)Component.m_237119_());
    public static final KnockdownMultiHitAttack<AnubisSpec> REKKA_FINISHER = (KnockdownMultiHitAttack)new KnockdownMultiHitAttack(0, 40, 1.0f, 7.0f, 15, 2.0f, 0.9f, 0.0f, (IntCollection)IntSet.of((int)32), 35).withHitSpark(JParticleType.SWEEP_ATTACK);
    public static final Rekka3Attack REKKA3 = (Rekka3Attack)((Rekka3Attack)((Rekka3Attack)((Rekka3Attack)new Rekka3Attack(10, 40, 1.0f, 4.0f, 15, 1.75f, 0.6f, -0.1f, (IntCollection)IntSet.of((int)8, (int)20, (int)32)).withFollowup(REKKA_FINISHER)).withSound(JSoundRegistry.ANUBIS_REKKA3)).withImpactSound(JSoundRegistry.IMPACT_4)).withInfo((Component)Component.m_237113_((String)"Cleaving Strikes (3 Hits)"), (Component)Component.m_237113_((String)"last hit knocks down if on 0 Bloodlust"));
    public static final LowKickAttack LOW_KICK = (LowKickAttack)((LowKickAttack)((LowKickAttack)new LowKickAttack(5, 10, 17, 1.5f, 6.0f, 15, 1.33f, 0.3f, 0.0f, 0.3f).withImpactSound(JSoundRegistry.IMPACT_3)).withStaticY()).withInfo((Component)Component.m_237113_((String)"Low Kick"), (Component)Component.m_237113_((String)"sheathed-only, launches slightly up"));
    public static final SimpleAnubisMultiHitAttack UNSHEATHING_SWEEP = (SimpleAnubisMultiHitAttack)((SimpleAnubisMultiHitAttack)new SimpleAnubisMultiHitAttack(5, 16, 1.0f, 3.0f, 10, 1.25f, 0.3f, 0.3f, (IntCollection)IntSet.of((int)6, (int)10), true).withImpactSound(JSoundRegistry.IMPACT_3)).withInfo((Component)Component.m_237113_((String)"Unsheating Sweep"), (Component)Component.m_237113_((String)"2 hits, knocks down"));
    public static final UnsheathingAttack UNSHEATHING_ATTACK = (UnsheathingAttack)((UnsheathingAttack)((UnsheathingAttack)((UnsheathingAttack)new UnsheathingAttack(5, 6, 12, 1.0f, 5.0f, 13, 1.75f, 0.5f, 0.0f).withCrouchingVariant(UNSHEATHING_SWEEP)).withImpactSound(SoundEvents.f_12317_)).withHitSpark(JParticleType.SWEEP_ATTACK)).withInfo((Component)Component.m_237113_((String)"Unsheathing Attack"), (Component)Component.m_237113_((String)"unsheathes Anubis"));
    private int ticksSinceLastHit = 0;
    protected float attackSpeedMult = 1.0f;

    public AnubisSpec(LivingEntity livingEntity) {
        super((SpecType)JSpecTypeRegistry.ANUBIS.get(), livingEntity);
    }

    public void tryIncrementBloodlust(Set<LivingEntity> targets) {
        LivingEntity target2;
        if (targets.isEmpty()) {
            return;
        }
        boolean hit = true;
        for (LivingEntity target2 : targets) {
            if (!JUtils.isBlocking(target2)) continue;
            hit = false;
            break;
        }
        if (hit && (target2 = this.user) instanceof Player) {
            Player playerEntity = (Player)target2;
            AnubisSpec anubisSpec = (AnubisSpec)JUtils.getSpec((LivingEntity)playerEntity);
            anubisSpec.setTicksSinceLastHit(0);
            if (anubisSpec.attackSpeedMult < 2.0f) {
                anubisSpec.attackSpeedMult += 0.2f;
                JComponentPlatformUtils.getMiscData((LivingEntity)playerEntity).setAttackSpeedMult(anubisSpec.attackSpeedMult);
            }
        }
    }

    public void unsheatheAttack(@Nullable Set<LivingEntity> targets) {
        Level level = this.user.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.user.m_21205_().m_150930_((Item)JItemRegistry.ANUBIS_SHEATHED.get())) {
                JUtils.serverPlaySound((SoundEvent)JSoundRegistry.ANUBIS_UNSHEATHE.get(), serverWorld, this.user.m_20182_());
                this.user.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)JItemRegistry.ANUBIS.get()));
            }
            if (this.user.m_21206_().m_150930_((Item)JItemRegistry.ANUBIS_SHEATHED.get())) {
                JUtils.serverPlaySound((SoundEvent)JSoundRegistry.ANUBIS_UNSHEATHE.get(), serverWorld, this.user.m_20182_());
                this.user.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)JItemRegistry.ANUBIS.get()));
            }
        }
    }

    private static void registerMoves(MoveMap<AnubisSpec, State> moves) {
        moves.register(MoveClass.HEAVY, POMMEL, CooldownType.HEAVY, State.POMMEL);
        moves.register(MoveClass.SPECIAL1, SLASH, CooldownType.SPECIAL1, State.SLASH).withAerialVariant(State.AERIAL_CLEAVE);
        moves.register(MoveClass.SPECIAL1, UNSHEATHING_ATTACK, CooldownType.SPECIAL1, State.UNSHEATHING_ATTACK).withCrouchingVariant(State.UNSHEATHING_SWEEP);
        moves.register(MoveClass.SPECIAL2, REKKA2, CooldownType.SPECIAL2, State.REKKA2);
        moves.register(MoveClass.SPECIAL3, REKKA3, CooldownType.SPECIAL2, State.REKKA3);
        moves.register(MoveClass.SPECIAL3, LOW_KICK, CooldownType.SPECIAL3, State.SWEEP);
    }

    private static boolean isHoldingSheathedAnubis(AnubisSpec spec) {
        return spec.user.m_21055_((Item)JItemRegistry.ANUBIS_SHEATHED.get());
    }

    public boolean isHoldingSheathedAnubis() {
        return AnubisSpec.isHoldingSheathedAnubis(this);
    }

    public static boolean isHoldingAnubis(AnubisSpec spec) {
        return spec.user.m_21055_((Item)JItemRegistry.ANUBIS.get());
    }

    public boolean isHoldingAnubis() {
        return AnubisSpec.isHoldingAnubis(this);
    }

    @Override
    public AnubisSpec getThis() {
        return this;
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        switch (moveClass) {
            case HEAVY: {
                return this.handleMove(POMMEL, CooldownType.HEAVY, this.isHoldingAnubis() ? State.POMMEL : State.POMMEL_IN, this.attackSpeedMult);
            }
            case SPECIAL1: {
                boolean s;
                if (this.isHoldingAnubis()) {
                    s = this.getUserOrThrow().m_20096_() ? this.handleMove(SLASH, CooldownType.SPECIAL1, State.SLASH, this.attackSpeedMult) : this.handleMove(AERIAL_CLEAVE, CooldownType.SPECIAL1, State.AERIAL_CLEAVE, this.attackSpeedMult);
                } else if (this.isHoldingSheathedAnubis()) {
                    s = this.getUserOrThrow().m_6144_() ? this.handleMove(UNSHEATHING_SWEEP, CooldownType.SPECIAL1, State.UNSHEATHING_SWEEP, this.attackSpeedMult) : this.handleMove(UNSHEATHING_ATTACK, CooldownType.SPECIAL1, State.UNSHEATHING_ATTACK, this.attackSpeedMult);
                } else {
                    return false;
                }
                return s;
            }
            case SPECIAL3: {
                boolean s;
                if (this.isHoldingAnubis()) {
                    s = this.handleMove(REKKA3, CooldownType.SPECIAL2, State.REKKA3, this.attackSpeedMult);
                } else {
                    s = this.handleMove(LOW_KICK, CooldownType.SPECIAL3, State.SWEEP, this.attackSpeedMult);
                    this.user.m_7292_(new MobEffectInstance(MobEffects.f_19597_, LOW_KICK.getDuration(), 2, true, false));
                }
                return s;
            }
        }
        return this.handleMove(moveClass, this.attackSpeedMult);
    }

    @Override
    public void tickSpec() {
        super.tickSpec();
        if (++this.ticksSinceLastHit > 80 && this.attackSpeedMult > 1.0f) {
            this.ticksSinceLastHit = 0;
            this.attackSpeedMult -= 0.2f;
            JComponentPlatformUtils.getMiscData(this.user).setAttackSpeedMult(this.attackSpeedMult);
        }
    }

    public void setTicksSinceLastHit(int ticksSinceLastHit) {
        this.ticksSinceLastHit = ticksSinceLastHit;
    }

    public float getAttackSpeedMult() {
        return this.attackSpeedMult;
    }

    public static enum State implements SpecAnimationState<AnubisSpec>
    {
        SLASH("an.slsh"),
        POMMEL("an.pom"),
        POMMEL_IN("an.pmi"),
        REKKA2("an.2hit"),
        REKKA3("an.3hit"),
        SWEEP("an.swp"),
        AERIAL_CLEAVE("an.acl"),
        UNSHEATHING_ATTACK("an.usa"),
        UNSHEATHING_SWEEP("an.uss");

        private final String key;

        private State(String key) {
            this.key = key;
        }

        @Override
        public String getKey(AnubisSpec spec) {
            return this.key;
        }
    }
}

