/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.spec;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.SpecData;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.SpecAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;

public class BrawlerSpec
extends JSpec<BrawlerSpec, State> {
    public static final MoveSet<BrawlerSpec, State> MOVE_SET = MoveSetManager.create(JSpecTypeRegistry.BRAWLER, BrawlerSpec::registerMoves, State.class);
    public static final SpecData DATA = SpecData.builder().name((Component)Component.m_237115_((String)"spec.jcraft.brawler")).description((Component)Component.m_237113_((String)"Close-range pressure and combo extension tool")).details((Component)Component.m_237113_((String)"Important hitconfirm: (any stand move)~stand.OFF>Combo>stand.ON+(any stand move)")).build();
    public static final SimpleUppercutAttack<BrawlerSpec> HEAVY = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 10, 21, 1.0f, 6.0f, 15, 1.5f, 0.3f, 0.0f, 0.3f).withImpactSound(JSoundRegistry.IMPACT_3)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Uppercut"), (Component)Component.m_237113_((String)"medium speed"));
    public static final SimpleAttack<BrawlerSpec> TORNADO = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(200, 12, 20, 1.0f, 7.0f, 20, 1.6f, 0.4f, -0.1f).withCrouchingVariant(HEAVY)).withImpactSound(JSoundRegistry.IMPACT_3)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withArmor(3)).withInfo((Component)Component.m_237113_((String)"Tornado Kick"), (Component)Component.m_237113_((String)"3 points of armor, high stun"));
    public static final SimpleMultiHitAttack<BrawlerSpec> COMBO = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(360, 26, 1.0f, 4.0f, 15, 1.5f, 0.2f, -0.1f, (IntCollection)IntSet.of((int)5, (int)10, (int)19)).withImpactSound(JSoundRegistry.IMPACT_2)).withBlockStun(5)).withInfo((Component)Component.m_237113_((String)"Combo"), (Component)Component.m_237113_((String)"hits 3 times, combo starter/extender"));
    public static final SimpleAttack<BrawlerSpec> GUT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 11, 18, 1.0f, 6.0f, 16, 1.5f, 0.4f, 0.0f).withImpactSound(JSoundRegistry.IMPACT_3)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Gut Punch"), (Component)Component.m_237113_((String)"good stun"));
    public static final KnockdownAttack<BrawlerSpec> SWEEP = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 11, 18, 1.0f, 5.0f, 16, 1.5f, 0.6f, 0.85f, 25).withImpactSound(JSoundRegistry.IMPACT_2)).withStaticY()).withInfo((Component)Component.m_237113_((String)"SWEEP"), (Component)Component.m_237113_((String)"knocks down"));
    public static final SimpleAttack<BrawlerSpec> LOW_KICK = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 11, 1.0f, 4.0f, 10, 1.25f, 0.15f, 0.35f).withCrouchingVariant(SWEEP)).withImpactSound(JSoundRegistry.IMPACT_6)).withExtraHitBox(0.25, 0.0, 1.0)).withStaticY()).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withInfo((Component)Component.m_237113_((String)"Right Low Kick"), (Component)Component.m_237113_((String)"fast jab"));

    public BrawlerSpec(LivingEntity livingEntity) {
        super((SpecType)JSpecTypeRegistry.BRAWLER.get(), livingEntity);
    }

    private static void registerMoves(MoveMap<BrawlerSpec, State> moves) {
        moves.register(MoveClass.HEAVY, TORNADO, CooldownType.HEAVY, State.TORNADO).withCrouchingVariant(State.HEAVY);
        moves.register(MoveClass.BARRAGE, COMBO, CooldownType.BARRAGE, State.COMBO);
        moves.register(MoveClass.SPECIAL1, LOW_KICK, CooldownType.SPECIAL1, State.LOW_KICK).withCrouchingVariant(State.SWEEP);
        moves.register(MoveClass.SPECIAL2, GUT, CooldownType.SPECIAL2, State.GUT);
    }

    @Override
    public BrawlerSpec getThis() {
        return this;
    }

    public static enum State implements SpecAnimationState<BrawlerSpec>
    {
        HEAVY("br.upct"),
        TORNADO("br.kck"),
        COMBO("br.3hit"),
        GUT("br.gut"),
        SWEEP("br.low"),
        LOW_KICK("br.lkk");

        private final String key;

        private State(String key) {
            this.key = key;
        }

        @Override
        public String getKey(BrawlerSpec spec) {
            return this.key;
        }
    }
}

