/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.spec;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.component.living.CommonVampireComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.spec.SpecData;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleHoldableMove;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.attack.moves.vampire.BloodSuckAttack;
import net.arna.jcraft.common.attack.moves.vampire.BloodSuckHitsAttack;
import net.arna.jcraft.common.attack.moves.vampire.NightVisionMove;
import net.arna.jcraft.common.attack.moves.vampire.ReviveMove;
import net.arna.jcraft.common.attack.moves.vampire.SpaceRipperAttack;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.SpecAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;

public class VampireSpec
extends JSpec<VampireSpec, State> {
    public static final MoveSet<VampireSpec, State> MOVE_SET = MoveSetManager.create(JSpecTypeRegistry.VAMPIRE, VampireSpec::registerMoves, State.class);
    public static final SpecData DATA = SpecData.builder().name((Component)Component.m_237115_((String)"spec.jcraft.vampire")).description((Component)Component.m_237113_((String)"Supernatural all-ranger")).details((Component)Component.m_237113_((String)"PASSIVES: Burns in sunlight, Replaces hunger with blood, Night vision\nExcellent frametraps with Sweep or Axe Kick.\nBloodsuck is extremely rewarding and allows linking into almost any move.")).build();
    public static final SimpleUppercutAttack<VampireSpec> AIR_KICK = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 6, 12, 1.0f, 5.0f, 14, 1.5f, 0.2f, 0.5f, -0.5f).withImpactSound(JSoundRegistry.IMPACT_1)).withStaticY()).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Axe Kick"), (Component)Component.m_237113_((String)"jab"));
    public static final SimpleUppercutAttack<VampireSpec> SWEEP = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 6, 12, 1.0f, 5.0f, 12, 1.5f, 0.2f, 0.5f, 0.5f).withImpactSound(JSoundRegistry.IMPACT_1)).withStaticY()).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withInfo((Component)Component.m_237113_((String)"Sweep Kick"), (Component)Component.m_237113_((String)"fast launcher"));
    public static final SimpleAttack<VampireSpec> ROUNDHOUSE = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 8, 15, 1.0f, 6.0f, 19, 1.5f, 1.5f, 0.0f).withCrouchingVariant(SWEEP)).withAerialVariant(AIR_KICK)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Wheel Kick"), (Component)Component.m_237113_((String)"fast launcher"));
    public static final SimpleMultiHitAttack<VampireSpec> COMBO = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(240, 23, 1.0f, 2.5f, 12, 1.5f, 0.2f, -0.1f, (IntCollection)IntSet.of((int[])new int[]{5, 8, 12, 16, 20})).withImpactSound(JSoundRegistry.IMPACT_1)).withBlockStun(5)).withInfo((Component)Component.m_237113_((String)"Beatdown"), (Component)Component.m_237113_((String)"hits 5 times, combo starter/extender"));
    public static final BloodSuckHitsAttack BLOODSUCK_HITS = (BloodSuckHitsAttack)((BloodSuckHitsAttack)new BloodSuckHitsAttack(0, 25, 1.0f, 4.0f, 5, 1.5f, 0.6f, -0.1f, (IntCollection)IntSet.of((int)8, (int)16, (int)24)).withStunType(StunType.UNBURSTABLE)).withInfo((Component)Component.m_237113_((String)"Blood Suck (Hit)"), (Component)Component.m_237119_());
    public static final BloodSuckAttack BLOODSUCK = (BloodSuckAttack)((BloodSuckAttack)((BloodSuckAttack)((BloodSuckAttack)new BloodSuckAttack(240, 10, 18, 1.0f, 1.0f, BLOODSUCK_HITS.getDuration(), 1.5f, 0.0f, 0.0f, BLOODSUCK_HITS, BLOODSUCK_HITS.getDuration(), 2.0).withSound(JSoundRegistry.VAMPIRE_GRAB_HIT)).withImpactSound(JSoundRegistry.IMPACT_9)).withHitSpark(JParticleType.BACK_STAB)).withInfo((Component)Component.m_237113_((String)"Blood Suck"), (Component)Component.m_237113_((String)"blockable grab"));
    public static final SpaceRipperAttack SPACE_RIPPER_ATTACK = (SpaceRipperAttack)new SpaceRipperAttack(300, 1, 10, 1.0f).withInfo((Component)Component.m_237113_((String)"Space Ripper Stingy Eyes (Fire)"), (Component)Component.m_237119_());
    public static final SimpleHoldableMove<VampireSpec> SPACE_RIPPER_CHARGE = (SimpleHoldableMove)((SimpleHoldableMove)((SimpleHoldableMove)((SimpleHoldableMove)new SimpleHoldableMove<VampireSpec>(300, 0, 32, 1.0f, 14).withFollowup(SPACE_RIPPER_ATTACK)).withSound(JSoundRegistry.VAMPIRE_LASER)).shouldSetMoveStun()).withInfo((Component)Component.m_237113_((String)"Space Ripper Stingy Eyes"), (Component)Component.m_237113_((String)"Chargeable laser beam attack.\nLaser velocity depends on charge time.\nAfter charging for 1.2s, becomes unblockable.\n"));
    public static final NightVisionMove TOGGLE_NV = (NightVisionMove)new NightVisionMove(20).withInfo((Component)Component.m_237113_((String)"Toggle Night Vision"), (Component)Component.m_237119_());
    public static final ReviveMove REVIVE_MOVE = (ReviveMove)((ReviveMove)((ReviveMove)new ReviveMove(300, 16, 20, 5.0f).withCrouchingVariant(TOGGLE_NV)).withSound(JSoundRegistry.VAMPIRE_REANIMATE)).withInfo((Component)Component.m_237113_((String)"Resurrection"), (Component)Component.m_237113_((String)"revives humanoid/undead enemies within 5 meters, that died within the last 1 minute"));
    private final CommonVampireComponent vampireComponent;

    public VampireSpec(LivingEntity livingEntity) {
        super((SpecType)JSpecTypeRegistry.VAMPIRE.get(), livingEntity);
        this.vampireComponent = JComponentPlatformUtils.getVampirism(livingEntity);
    }

    private static void registerMoves(MoveMap<VampireSpec, State> moves) {
        MoveMap.Entry<VampireSpec, State> hvy = moves.register(MoveClass.HEAVY, ROUNDHOUSE, CooldownType.HEAVY, State.ROUNDHOUSE);
        hvy.withCrouchingVariant(State.SWEEP);
        hvy.withAerialVariant(State.AXE_KICK);
        moves.register(MoveClass.BARRAGE, COMBO, CooldownType.BARRAGE, State.COMBO);
        moves.register(MoveClass.SPECIAL1, SPACE_RIPPER_CHARGE, CooldownType.SPECIAL1, State.SPACE_RIPPER_CHARGE).withFollowup(State.SPACE_RIPPERS);
        moves.register(MoveClass.SPECIAL2, BLOODSUCK, CooldownType.SPECIAL2, State.BLOODSUCK);
        moves.register(MoveClass.SPECIAL3, REVIVE_MOVE, CooldownType.SPECIAL3, State.RESURRECT).withCrouchingVariant(null);
    }

    @Override
    public VampireSpec getThis() {
        return this;
    }

    public CommonVampireComponent getVampireComponent() {
        return this.vampireComponent;
    }

    public static enum State implements SpecAnimationState<VampireSpec>
    {
        SWEEP("vm.swp"),
        ROUNDHOUSE("vm.rnd"),
        AXE_KICK("vm.axe"),
        COMBO("vm.5hit"),
        SPACE_RIPPER_CHARGE("vm.srsc"),
        SPACE_RIPPERS("vm.srse"),
        BLOODSUCK("vm.bsk"),
        BLOODSUCK_HIT("vm.bsh"),
        RESURRECT("vm.rsr");

        private final String key;

        private State(String key) {
            this.key = key;
        }

        @Override
        public String getKey(VampireSpec spec) {
            return this.key;
        }
    }
}

