/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.splatter;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.Pair;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.common.splatter.Splatter;
import net.arna.jcraft.common.splatter.SplatterSplitter;
import net.arna.jcraft.common.splatter.SplatterType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class JSplatterManager {
    private final Level world;
    private final Set<Splatter> splatters = ConcurrentHashMap.newKeySet();

    public JSplatterManager(Level world) {
        this.world = world;
    }

    public Splatter addSplatter(Vec3 pos, SplatterType type) {
        return this.addSplatter(pos, type, 0.5f, null);
    }

    public Splatter addSplatter(Vec3 pos, SplatterType type, float range, @Nullable Entity creator) {
        return this.addSplatter(pos, type, range, range, creator);
    }

    public Splatter addSplatter(Vec3 pos, SplatterType type, float xRange, float zRange, @Nullable Entity creator) {
        Pair<Vec3, Direction> anchoredPos = this.anchorPos(pos);
        pos = (Vec3)anchoredPos.left();
        Splatter splatter = new Splatter(this.world, pos, ((Direction)anchoredPos.right()).m_122424_(), type, xRange, zRange, creator);
        this.splatters.add(splatter);
        if (this.world.f_46443_) {
            return splatter;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.writeSplatter(splatter, buf);
        NetworkManager.sendToPlayers(JUtils.around((ServerLevel)this.world, pos, 64.0), (ResourceLocation)JPacketRegistry.S2C_SPLATTER, (FriendlyByteBuf)buf);
        return splatter;
    }

    private Pair<Vec3, Direction> anchorPos(Vec3 position) {
        BlockPos bPos = BlockPos.m_274446_((Position)position);
        Direction direction = Direction.m_235666_().filter(d -> SplatterSplitter.isValidAnchor(this.world, bPos.m_121945_(d))).min((d1, d2) -> Double.compare(this.getDistanceToAnchor(position, (Direction)d1), this.getDistanceToAnchor(position, (Direction)d2))).orElse(Direction.DOWN);
        double x = position.m_7096_();
        double y = position.m_7098_();
        double z = position.m_7094_();
        DoubleUnaryOperator modifier = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? Math::ceil : Math::floor;
        switch (direction.m_122434_()) {
            case X: {
                x = modifier.applyAsDouble(x);
                break;
            }
            case Y: {
                y = modifier.applyAsDouble(y);
                break;
            }
            case Z: {
                z = modifier.applyAsDouble(z);
            }
        }
        return Pair.of((Object)new Vec3(x, y, z), (Object)direction);
    }

    private double getDistanceToAnchor(Vec3 position, Direction direction) {
        DoubleUnaryOperator modifier = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? Math::ceil : Math::floor;
        return Math.abs(direction.m_122434_().m_6150_(position.m_7096_() - modifier.applyAsDouble(position.m_7096_()), position.m_7098_() - modifier.applyAsDouble(position.m_7098_()), position.m_7094_() - modifier.applyAsDouble(position.m_7094_())));
    }

    public void writeSplatter(Splatter splatter, FriendlyByteBuf buf) {
        Vec3 pos = splatter.getPos();
        buf.writeDouble(pos.m_7096_());
        buf.writeDouble(pos.m_7098_());
        buf.writeDouble(pos.m_7094_());
        buf.m_130068_((Enum)splatter.getDirection());
        buf.m_130068_((Enum)splatter.getType());
        buf.writeFloat(splatter.getXRange());
        buf.writeFloat(splatter.getZRange());
    }

    public Splatter readSplatter(FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        Direction direction = (Direction)buf.m_130066_(Direction.class);
        SplatterType type = (SplatterType)buf.m_130066_(SplatterType.class);
        float xRange = buf.readFloat();
        float zRange = buf.readFloat();
        Splatter splatter = new Splatter(this.world, new Vec3(x, y, z), direction, type, xRange, zRange, null);
        this.splatters.add(splatter);
        return splatter;
    }

    public void tick() {
        this.splatters.forEach(Splatter::tick);
        this.splatters.removeIf(Splatter::isRemoved);
    }

    public void iterateSplatters(Consumer<Splatter> consumer) {
        this.splatters.forEach(consumer);
    }
}

