/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.splatter;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.splatter.SplatterSection;
import net.arna.jcraft.common.splatter.SplatterSplitter;
import net.arna.jcraft.common.splatter.SplatterType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class Splatter {
    public static final int MAX_AGE = 80;
    private final Level world;
    private final Vec3 pos;
    private final Direction direction;
    private final SplatterType type;
    @Nullable
    private final Entity creator;
    private final float xRange;
    private final float zRange;
    private final List<SplatterSection> sections;
    private final AtomicReference<Object> anchor = new AtomicReference();
    private final float offset = (float)(Math.random() * 0.0019 + 1.0E-4);
    private final AABB mainBox;
    private int age;
    private boolean removed;

    Splatter(Level world, Vec3 pos, Direction direction, SplatterType type, float xRange, float zRange, @Nullable Entity creator) {
        this.world = world;
        this.pos = pos;
        this.direction = direction;
        this.type = type;
        this.xRange = xRange;
        this.zRange = zRange;
        this.creator = creator;
        this.sections = SplatterSplitter.splitAndWrap(this);
        Vector3f min = Splatter.findEdge(this.sections, false);
        Vector3f max = Splatter.findEdge(this.sections, true);
        this.mainBox = new AABB(new Vec3(min), new Vec3(max)).m_82400_(0.1);
    }

    private static Vector3f findEdge(List<SplatterSection> sections, boolean max) {
        float f = max ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        BiFunction<Float, Float, Float> function = max ? Math::max : Math::min;
        return sections.stream().map(max ? SplatterSection::getMaxPos : SplatterSection::getMinPos).reduce(new Vector3f(f, f, f), (current, vec) -> {
            float x = ((Float)function.apply(Float.valueOf(current.x()), Float.valueOf(vec.x()))).floatValue();
            float y = ((Float)function.apply(Float.valueOf(current.y()), Float.valueOf(vec.y()))).floatValue();
            float z = ((Float)function.apply(Float.valueOf(current.z()), Float.valueOf(vec.z()))).floatValue();
            current.set(x, y, z);
            return current;
        });
    }

    public float getStrength(float tickDelta) {
        if ((double)tickDelta <= 0.001) {
            return Splatter.getStrength(this.type.getMaxAge(), this.age);
        }
        return Mth.m_269140_((float)tickDelta, (int)((int)Splatter.getStrength(this.type.getMaxAge(), this.age - 1)), (int)((int)Splatter.getStrength(this.type.getMaxAge(), this.age)));
    }

    private static float getStrength(int maxAge, int age) {
        return Mth.m_14036_((float)((float)(maxAge - age) / 20.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        if (this.removed) {
            return;
        }
        if (this.age++ == this.type.getMaxAge()) {
            this.removed = true;
            return;
        }
        if (!this.world.f_46443_ && this.type == SplatterType.ACID && this.age % 4 == 0) {
            for (LivingEntity hit : this.world.m_6443_(LivingEntity.class, this.mainBox, EntitySelector.f_20403_)) {
                StandEntity stand;
                if (!this.intersects(hit.m_20191_()) || hit.m_20365_(this.creator) || hit instanceof StandEntity && (stand = (StandEntity)hit).getUser() == this.creator) continue;
                hit.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.WSPOISON.get(), 20, 0, true, false));
                hit.m_6469_(JDamageSources.whitesnakePoison(this.creator), 2.0f);
            }
        }
        this.removed = this.sections.stream().filter(section -> !section.isRemoved()).peek(SplatterSection::tick).allMatch(SplatterSection::isRemoved);
    }

    public boolean intersects(AABB box) {
        if (box == null || !this.mainBox.m_82381_(box)) {
            return false;
        }
        return this.sections.stream().filter(section -> !section.isRemoved()).map(SplatterSection::getHitBox).anyMatch(arg_0 -> ((AABB)box).m_82381_(arg_0));
    }

    public Level getWorld() {
        return this.world;
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public SplatterType getType() {
        return this.type;
    }

    @Nullable
    public Entity getCreator() {
        return this.creator;
    }

    public float getXRange() {
        return this.xRange;
    }

    public float getZRange() {
        return this.zRange;
    }

    public List<SplatterSection> getSections() {
        return this.sections;
    }

    public float getOffset() {
        return this.offset;
    }

    public AABB getMainBox() {
        return this.mainBox;
    }

    public int getAge() {
        return this.age;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Splatter)) {
            return false;
        }
        Splatter other = (Splatter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getXRange(), other.getXRange()) != 0) {
            return false;
        }
        if (Float.compare(this.getZRange(), other.getZRange()) != 0) {
            return false;
        }
        if (Float.compare(this.getOffset(), other.getOffset()) != 0) {
            return false;
        }
        if (this.getAge() != other.getAge()) {
            return false;
        }
        if (this.isRemoved() != other.isRemoved()) {
            return false;
        }
        Level this$world = this.getWorld();
        Level other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        Vec3 this$pos = this.getPos();
        Vec3 other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        SplatterType this$type = this.getType();
        SplatterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Entity this$creator = this.getCreator();
        Entity other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        List<SplatterSection> this$sections = this.getSections();
        List<SplatterSection> other$sections = other.getSections();
        if (this$sections == null ? other$sections != null : !((Object)this$sections).equals(other$sections)) {
            return false;
        }
        BlockPos this$anchor = this.getAnchor();
        BlockPos other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) {
            return false;
        }
        AABB this$mainBox = this.getMainBox();
        AABB other$mainBox = other.getMainBox();
        return !(this$mainBox == null ? other$mainBox != null : !this$mainBox.equals(other$mainBox));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Splatter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getXRange());
        result = result * 59 + Float.floatToIntBits(this.getZRange());
        result = result * 59 + Float.floatToIntBits(this.getOffset());
        result = result * 59 + this.getAge();
        result = result * 59 + (this.isRemoved() ? 79 : 97);
        Level $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        Vec3 $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        SplatterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Entity $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        List<SplatterSection> $sections = this.getSections();
        result = result * 59 + ($sections == null ? 43 : ((Object)$sections).hashCode());
        BlockPos $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
        AABB $mainBox = this.getMainBox();
        result = result * 59 + ($mainBox == null ? 43 : $mainBox.hashCode());
        return result;
    }

    public String toString() {
        return "Splatter(world=" + String.valueOf(this.getWorld()) + ", pos=" + String.valueOf(this.getPos()) + ", direction=" + String.valueOf(this.getDirection()) + ", type=" + String.valueOf((Object)this.getType()) + ", creator=" + String.valueOf(this.getCreator()) + ", xRange=" + this.getXRange() + ", zRange=" + this.getZRange() + ", sections=" + String.valueOf(this.getSections()) + ", anchor=" + String.valueOf(this.getAnchor()) + ", offset=" + this.getOffset() + ", mainBox=" + String.valueOf(this.getMainBox()) + ", age=" + this.getAge() + ", removed=" + this.isRemoved() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockPos getAnchor() {
        Object $value = this.anchor.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.anchor;
            synchronized (atomicReference) {
                $value = this.anchor.get();
                if ($value == null) {
                    BlockPos actualValue = BlockPos.m_274446_((Position)this.pos).m_7495_();
                    $value = actualValue == null ? this.anchor : actualValue;
                    this.anchor.set($value);
                }
            }
        }
        return (BlockPos)($value == this.anchor ? null : $value);
    }
}

