/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.splatter;

import lombok.NonNull;
import net.arna.jcraft.common.splatter.SplatterSplitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SplatterSection {
    private final Level world;
    private final Direction direction;
    @NonNull
    private final Vector3f minPos;
    @NonNull
    private final Vector3f maxPos;
    private final Vector3f center;
    private final BlockPos blockPos;
    private final Vec2 minUv;
    private final Vec2 maxUv;
    private final AABB hitBox;
    private boolean removed;

    public SplatterSection(Level world, Direction direction, @NonNull Vector3f minPos, @NonNull Vector3f maxPos, Vec2 minUv, Vec2 maxUv) {
        if (minPos == null) {
            throw new NullPointerException("minPos is marked non-null but is null");
        }
        if (maxPos == null) {
            throw new NullPointerException("maxPos is marked non-null but is null");
        }
        this.world = world;
        this.direction = direction;
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.center = SplatterSection.calcCenter(minPos, maxPos);
        this.blockPos = SplatterSection.getAnchor(this.center, direction);
        this.minUv = minUv;
        this.maxUv = maxUv;
        this.hitBox = new AABB(new Vec3(minPos), new Vec3(maxPos)).m_82369_(new Vec3(direction.m_253071_()).m_82490_(0.1));
    }

    public static BlockPos getAnchor(Vector3f center, Direction facing) {
        return BlockPos.m_274446_((Position)new Vec3(center).m_82549_(new Vec3(facing.m_253071_()).m_82490_(0.05)));
    }

    public static Vector3f calcCenter(Vector3f min, Vector3f max) {
        Vector3f center = new Vector3f((Vector3fc)min);
        Vector3f delta = new Vector3f((Vector3fc)max);
        delta.sub((Vector3fc)min);
        delta = delta.div(2.0f);
        center.add((Vector3fc)delta);
        return center;
    }

    public SplatterSection wrapped(Direction direction, Vector3f min, Vector3f max) {
        return this.wrapped(direction, min, max, UvModification.NONE);
    }

    public SplatterSection wrapped(Direction direction, Vector3f min, Vector3f max, UvModification uvModification) {
        Vec2 minUv = this.minUv;
        Vec2 maxUv = this.maxUv;
        if (uvModification.isFlip()) {
            minUv = new Vec2(minUv.f_82471_, minUv.f_82470_);
            maxUv = new Vec2(maxUv.f_82471_, maxUv.f_82470_);
        }
        if (uvModification.isSwap()) {
            Vec2 intermediary = minUv;
            minUv = maxUv;
            maxUv = intermediary;
        }
        if (uvModification.isUFlip()) {
            float intermediary = minUv.f_82470_;
            minUv = new Vec2(maxUv.f_82470_, minUv.f_82471_);
            maxUv = new Vec2(intermediary, maxUv.f_82471_);
        }
        if (uvModification.isVFlip()) {
            float intermediary = minUv.f_82471_;
            minUv = new Vec2(minUv.f_82470_, maxUv.f_82471_);
            maxUv = new Vec2(maxUv.f_82470_, intermediary);
        }
        return new SplatterSection(this.world, direction, new Vector3f((Vector3fc)min), new Vector3f((Vector3fc)max), minUv, maxUv);
    }

    public boolean hasValidAnchor() {
        BlockPos pos = this.blockPos.m_121945_(this.direction.m_122424_());
        return SplatterSplitter.isValidAnchor(this.world, pos);
    }

    public void tick() {
        if (this.removed) {
            return;
        }
        if (!this.hasValidAnchor() || SplatterSplitter.isValidAnchor(this.world, this.blockPos)) {
            this.removed = true;
        }
    }

    public String toString() {
        return "Section{direction=" + String.valueOf(this.direction) + ", minPos=" + String.valueOf(this.minPos) + ", maxPos=" + String.valueOf(this.maxPos) + ", center=" + String.valueOf(this.center) + ", minUv=" + String.format("[%f, %f]", Float.valueOf(this.minUv.f_82470_), Float.valueOf(this.minUv.f_82471_)) + ", maxUv=" + String.format("[%f, %f]", Float.valueOf(this.maxUv.f_82470_), Float.valueOf(this.maxUv.f_82471_)) + "}";
    }

    public Level getWorld() {
        return this.world;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @NonNull
    public Vector3f getMinPos() {
        return this.minPos;
    }

    @NonNull
    public Vector3f getMaxPos() {
        return this.maxPos;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Vec2 getMinUv() {
        return this.minUv;
    }

    public Vec2 getMaxUv() {
        return this.maxUv;
    }

    public AABB getHitBox() {
        return this.hitBox;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplatterSection)) {
            return false;
        }
        SplatterSection other = (SplatterSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRemoved() != other.isRemoved()) {
            return false;
        }
        Level this$world = this.getWorld();
        Level other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        Vector3f this$minPos = this.getMinPos();
        Vector3f other$minPos = other.getMinPos();
        if (this$minPos == null ? other$minPos != null : !this$minPos.equals(other$minPos)) {
            return false;
        }
        Vector3f this$maxPos = this.getMaxPos();
        Vector3f other$maxPos = other.getMaxPos();
        if (this$maxPos == null ? other$maxPos != null : !this$maxPos.equals(other$maxPos)) {
            return false;
        }
        Vector3f this$center = this.getCenter();
        Vector3f other$center = other.getCenter();
        if (this$center == null ? other$center != null : !this$center.equals(other$center)) {
            return false;
        }
        BlockPos this$blockPos = this.getBlockPos();
        BlockPos other$blockPos = other.getBlockPos();
        if (this$blockPos == null ? other$blockPos != null : !this$blockPos.equals(other$blockPos)) {
            return false;
        }
        Vec2 this$minUv = this.getMinUv();
        Vec2 other$minUv = other.getMinUv();
        if (this$minUv == null ? other$minUv != null : !this$minUv.equals(other$minUv)) {
            return false;
        }
        Vec2 this$maxUv = this.getMaxUv();
        Vec2 other$maxUv = other.getMaxUv();
        if (this$maxUv == null ? other$maxUv != null : !this$maxUv.equals(other$maxUv)) {
            return false;
        }
        AABB this$hitBox = this.getHitBox();
        AABB other$hitBox = other.getHitBox();
        return !(this$hitBox == null ? other$hitBox != null : !this$hitBox.equals(other$hitBox));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SplatterSection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRemoved() ? 79 : 97);
        Level $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        Vector3f $minPos = this.getMinPos();
        result = result * 59 + ($minPos == null ? 43 : $minPos.hashCode());
        Vector3f $maxPos = this.getMaxPos();
        result = result * 59 + ($maxPos == null ? 43 : $maxPos.hashCode());
        Vector3f $center = this.getCenter();
        result = result * 59 + ($center == null ? 43 : $center.hashCode());
        BlockPos $blockPos = this.getBlockPos();
        result = result * 59 + ($blockPos == null ? 43 : $blockPos.hashCode());
        Vec2 $minUv = this.getMinUv();
        result = result * 59 + ($minUv == null ? 43 : $minUv.hashCode());
        Vec2 $maxUv = this.getMaxUv();
        result = result * 59 + ($maxUv == null ? 43 : $maxUv.hashCode());
        AABB $hitBox = this.getHitBox();
        result = result * 59 + ($hitBox == null ? 43 : $hitBox.hashCode());
        return result;
    }

    public static enum UvModification {
        NONE(false, false, false, false),
        FLIP(true, false, false, false),
        FLIP_U_FLIP(true, false, true, false),
        FLIP_V_FLIP(true, false, false, true),
        SWAP(true, true, false, false),
        SWAP_U_FLIP(true, true, true, false),
        SWAP_V_FLIP(true, true, false, true),
        U_FLIP(false, false, true, false),
        V_FLIP(false, false, false, true);

        private final boolean flip;
        private final boolean swap;
        private final boolean uFlip;
        private final boolean vFlip;

        private UvModification(boolean flip, boolean swap, boolean uFlip, boolean vFlip) {
            this.flip = flip;
            this.swap = swap;
            this.uFlip = uFlip;
            this.vFlip = vFlip;
        }

        public boolean isFlip() {
            return this.flip;
        }

        public boolean isSwap() {
            return this.swap;
        }

        public boolean isUFlip() {
            return this.uFlip;
        }

        public boolean isVFlip() {
            return this.vFlip;
        }
    }
}

