/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.splatter;

import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.floats.FloatFloatPair;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.arna.jcraft.common.splatter.Splatter;
import net.arna.jcraft.common.splatter.SplatterSection;
import net.arna.jcraft.common.util.extensions.VecExtensions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

final class SplatterSplitter {
    public static boolean isValidAnchor(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60838_((BlockGetter)world, pos);
    }

    public static List<SplatterSection> splitAndWrap(Splatter splatter) {
        return SplatterSplitter.wrap(splatter, SplatterSplitter.split(splatter));
    }

    private static Stream<SplatterSection> split(Splatter splatter) {
        Direction direction = splatter.getDirection();
        boolean flipUvHorizontally = direction.m_122421_() == Direction.AxisDirection.NEGATIVE;
        Vec2 minUv = new Vec2(flipUvHorizontally ? 1.0f : 0.0f, 0.0f);
        Vec2 maxUv = new Vec2(flipUvHorizontally ? 0.0f : 1.0f, 1.0f);
        Pair<Direction.Axis, Direction.Axis> axes = SplatterSplitter.getAxesForDirection(direction);
        Direction.Axis a1 = (Direction.Axis)axes.first();
        Direction.Axis a2 = (Direction.Axis)axes.second();
        float xRange = splatter.getXRange();
        float zRange = splatter.getZRange();
        Vec3 center = splatter.getPos();
        Vec3 min = SplatterSplitter.add(SplatterSplitter.add(center, a1, (double)(-xRange)), a2, (double)(-zRange));
        Vec3 max = SplatterSplitter.add(SplatterSplitter.add(center, a1, (double)xRange), a2, (double)zRange);
        return Streams.stream((Iterable)BlockPos.m_121940_((BlockPos)BlockPos.m_274446_((Position)min), (BlockPos)BlockPos.m_274446_((Position)max))).map(pos -> {
            double c1 = center.m_82507_(a1);
            double c2 = center.m_82507_(a2);
            int p1 = pos.m_123304_(a1);
            int p2 = pos.m_123304_(a2);
            double min1 = 1.0 - Mth.m_14008_((double)((double)(p1 + 1) - (c1 - (double)xRange)), (double)0.0, (double)1.0);
            double max1 = Mth.m_14008_((double)(c1 + (double)xRange - (double)p1), (double)0.0, (double)1.0);
            double min2 = 1.0 - Mth.m_14008_((double)((double)(p2 + 1) - (c2 - (double)zRange)), (double)0.0, (double)1.0);
            double max2 = Mth.m_14008_((double)(c2 + (double)zRange - (double)p2), (double)0.0, (double)1.0);
            if (Math.abs(max1 - min1) < 0.001 || Math.abs(max2 - min2) < 0.001) {
                return null;
            }
            float minU = SplatterSplitter.calcUv(min1 += (double)pos.m_123304_(a1), c1, xRange, minUv.f_82470_, maxUv.f_82470_);
            float maxU = SplatterSplitter.calcUv(max1 += (double)pos.m_123304_(a1), c1, xRange, minUv.f_82470_, maxUv.f_82470_);
            float minV = SplatterSplitter.calcUv(min2 += (double)pos.m_123304_(a2), c2, zRange, minUv.f_82471_, maxUv.f_82471_);
            float maxV = SplatterSplitter.calcUv(max2 += (double)pos.m_123304_(a2), c2, zRange, minUv.f_82471_, maxUv.f_82471_);
            Pair<Vec2, Vec2> uv = SplatterSplitter.packUv(minU, maxU, minV, maxV, direction);
            return new SplatterSection(splatter.getWorld(), direction, SplatterSplitter.pack((float)min1, (float)min2, a1, a2, center), SplatterSplitter.pack((float)max1, (float)max2, a1, a2, center), (Vec2)uv.left(), (Vec2)uv.right());
        }).filter(Objects::nonNull);
    }

    private static Vec3 add(Vec3 vec, Direction.Axis axis, double value) {
        return vec.m_82520_(axis == Direction.Axis.X ? value : 0.0, axis == Direction.Axis.Y ? value : 0.0, axis == Direction.Axis.Z ? value : 0.0);
    }

    private static void add(Vector3f vec, Direction.Axis axis, float value) {
        vec.add(axis == Direction.Axis.X ? value : 0.0f, axis == Direction.Axis.Y ? value : 0.0f, axis == Direction.Axis.Z ? value : 0.0f);
    }

    private static Vector3f pack(float v1, float v2, Direction.Axis a1, Direction.Axis a2, Vec3 fallback) {
        Vector3f res = new Vector3f();
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (axis == a1) {
                SplatterSplitter.add(res, axis, v1);
                continue;
            }
            if (axis == a2) {
                SplatterSplitter.add(res, axis, v2);
                continue;
            }
            SplatterSplitter.add(res, axis, (float)fallback.m_82507_(axis));
        }
        return res;
    }

    private static Pair<Vec2, Vec2> packUv(float minU, float maxU, float minV, float maxV, Direction direction) {
        boolean flipU = direction == Direction.EAST;
        boolean flipV = direction == Direction.SOUTH;
        Vec2 min = new Vec2(flipU ? maxU : minU, flipV ? maxV : minV);
        Vec2 max = new Vec2(flipU ? minU : maxU, flipV ? minV : maxV);
        return Pair.of((Object)min, (Object)max);
    }

    private static float calcUv(double sectionCoord, double centerCoord, float range, float min, float max) {
        return Mth.m_14179_((float)((float)((sectionCoord - centerCoord + (double)range) / (double)(2.0f * range))), (float)min, (float)max);
    }

    private static List<SplatterSection> wrap(Splatter splatter, Stream<SplatterSection> sections) {
        return sections.flatMap(section -> {
            List<ObjectBooleanPair<Direction>> anchors = SplatterSplitter.findAnchors(splatter, section);
            if (anchors == null) {
                return Stream.of(section);
            }
            Stream.Builder<SplatterSection> res = Stream.builder();
            Vector3f minP = new Vector3f((Vector3fc)section.getMinPos());
            Vector3f maxP = new Vector3f((Vector3fc)section.getMaxPos());
            for (ObjectBooleanPair<Direction> anchor : anchors) {
                boolean inside = anchor.rightBoolean();
                res.add(switch ((Direction)anchor.left()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.UP -> SplatterSplitter.wrapUp(section, minP, maxP, inside);
                    case Direction.DOWN -> SplatterSplitter.wrapDown(section, minP, maxP, inside);
                    case Direction.NORTH -> SplatterSplitter.wrapNorth(section, minP, maxP, inside);
                    case Direction.WEST -> SplatterSplitter.wrapWest(section, minP, maxP, inside);
                    case Direction.SOUTH -> SplatterSplitter.wrapSouth(section, minP, maxP, inside);
                    case Direction.EAST -> SplatterSplitter.wrapEast(section, minP, maxP, inside);
                });
            }
            return res.build().peek(s -> {
                float offset = 2.0f * splatter.getOffset();
                if (s.getDirection() == Direction.UP) {
                    s.getMinPos().add(offset, 0.0f, -offset);
                    s.getMaxPos().add(offset, 0.0f, offset);
                } else {
                    s.getMaxPos().add(0.0f, offset, 0.0f);
                }
            });
        }).toList();
    }

    private static SplatterSection wrapUp(SplatterSection section, Vector3f min, Vector3f max, boolean inside) {
        FloatFloatPair dims = SplatterSplitter.getDims(section.getDirection(), min, max);
        float width = dims.leftFloat();
        float height = dims.rightFloat();
        return switch (section.getDirection()) {
            case Direction.NORTH -> {
                if (inside) {
                    yield section.wrapped(Direction.UP, new Vector3f(min.x(), max.y(), min.z() - height), max);
                }
                yield section.wrapped(Direction.UP, min, new Vector3f(max.x(), min.y(), max.z() + height));
            }
            case Direction.SOUTH -> {
                if (inside) {
                    yield section.wrapped(Direction.UP, new Vector3f(min.x(), max.y(), min.z()), new Vector3f(max.x(), max.y(), max.z() + height));
                }
                yield section.wrapped(Direction.UP, new Vector3f(min.x(), min.y(), min.z() - height), new Vector3f(max.x(), min.y(), max.z()));
            }
            case Direction.WEST -> {
                if (inside) {
                    yield section.wrapped(Direction.UP, new Vector3f(min.x() - width, max.y(), min.z()), max);
                }
                yield section.wrapped(Direction.UP, min, new Vector3f(max.x() + width, min.y(), max.z()));
            }
            case Direction.EAST -> {
                if (inside) {
                    yield section.wrapped(Direction.UP, new Vector3f(min.x(), max.y(), min.z()), new Vector3f(max.x() + width, max.y(), max.z()));
                }
                yield section.wrapped(Direction.UP, new Vector3f(min.x() - width, min.y(), min.z()), new Vector3f(max.x(), min.y(), max.z()));
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(section.getDirection()));
        };
    }

    private static SplatterSection wrapDown(SplatterSection section, Vector3f min, Vector3f max, boolean inside) {
        FloatFloatPair dims = SplatterSplitter.getDims(section.getDirection(), min, max);
        float width = dims.leftFloat();
        float height = dims.rightFloat();
        return switch (section.getDirection()) {
            case Direction.NORTH -> {
                if (inside) {
                    yield section.wrapped(Direction.DOWN, new Vector3f(min.x(), min.y(), min.z() - height), new Vector3f(max.x(), min.y(), max.z()), SplatterSection.UvModification.V_FLIP);
                }
                yield section.wrapped(Direction.DOWN, new Vector3f(min.x(), max.y(), min.z()), new Vector3f(max.x(), max.y(), max.z() + height), SplatterSection.UvModification.V_FLIP);
            }
            case Direction.SOUTH -> {
                if (inside) {
                    yield section.wrapped(Direction.DOWN, min, new Vector3f(max.x(), min.y(), max.z() + height), SplatterSection.UvModification.V_FLIP);
                }
                yield section.wrapped(Direction.DOWN, new Vector3f(min.x(), max.y(), min.z() - height), max, SplatterSection.UvModification.V_FLIP);
            }
            case Direction.WEST -> {
                if (inside) {
                    yield section.wrapped(Direction.DOWN, new Vector3f(min.x() - width, min.y(), min.z()), new Vector3f(max.x(), min.y(), max.z()), SplatterSection.UvModification.U_FLIP);
                }
                yield section.wrapped(Direction.DOWN, new Vector3f(min.x(), max.y(), min.z()), new Vector3f(max.x() + width, max.y(), max.z()), SplatterSection.UvModification.U_FLIP);
            }
            case Direction.EAST -> {
                if (inside) {
                    yield section.wrapped(Direction.DOWN, min, new Vector3f(max.x() + width, min.y(), max.z()), SplatterSection.UvModification.U_FLIP);
                }
                yield section.wrapped(Direction.DOWN, new Vector3f(min.x() - width, max.y(), min.z()), max, SplatterSection.UvModification.U_FLIP);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(section.getDirection()));
        };
    }

    private static SplatterSection wrapNorth(SplatterSection section, Vector3f min, Vector3f max, boolean inside) {
        FloatFloatPair dims = SplatterSplitter.getDims(section.getDirection(), min, max);
        float height = dims.rightFloat();
        return switch (section.getDirection()) {
            case Direction.UP -> {
                if (inside) {
                    yield section.wrapped(Direction.NORTH, min, new Vector3f(max.x(), max.y() + height, min.z()));
                }
                yield section.wrapped(Direction.NORTH, new Vector3f(min.x(), min.y() - height, max.z()), max);
            }
            case Direction.DOWN -> {
                if (inside) {
                    yield section.wrapped(Direction.NORTH, new Vector3f(min.x(), min.y() - height, min.z()), new Vector3f(max.x(), max.y(), max.z() - height), SplatterSection.UvModification.V_FLIP);
                }
                yield section.wrapped(Direction.NORTH, new Vector3f(min.x(), min.y(), max.z()), new Vector3f(max.x(), max.y() + height, min.z()), SplatterSection.UvModification.V_FLIP);
            }
            case Direction.WEST -> {
                if (inside) {
                    yield section.wrapped(Direction.NORTH, new Vector3f(min.x() - height, min.y(), min.z()), new Vector3f(max.x(), max.y(), min.z()), SplatterSection.UvModification.FLIP_U_FLIP);
                }
                yield section.wrapped(Direction.NORTH, new Vector3f(min.x() + height, min.y(), max.z()), max, SplatterSection.UvModification.FLIP);
            }
            case Direction.EAST -> {
                if (inside) {
                    yield section.wrapped(Direction.NORTH, min, new Vector3f(max.x() + height, max.y(), min.z()), SplatterSection.UvModification.SWAP_U_FLIP);
                }
                yield section.wrapped(Direction.NORTH, new Vector3f(min.x() - height, min.y(), max.z()), new Vector3f(max.x(), max.y(), max.z()), SplatterSection.UvModification.SWAP_U_FLIP);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(section.getDirection()));
        };
    }

    private static SplatterSection wrapWest(SplatterSection section, Vector3f min, Vector3f max, boolean inside) {
        FloatFloatPair dims = SplatterSplitter.getDims(section.getDirection(), min, max);
        float width = dims.leftFloat();
        return switch (section.getDirection()) {
            case Direction.UP -> {
                if (inside) {
                    yield section.wrapped(Direction.WEST, min, new Vector3f(max.x(), max.y() + width, max.z()));
                }
                yield section.wrapped(Direction.WEST, new Vector3f(min.x() + width, min.y() - width, min.z()), max);
            }
            case Direction.DOWN -> {
                if (inside) {
                    yield section.wrapped(Direction.WEST, new Vector3f(min.x(), min.y() - width, min.z()), max, SplatterSection.UvModification.U_FLIP);
                }
                yield section.wrapped(Direction.WEST, new Vector3f(min.x() + width, min.y(), min.z()), new Vector3f(max.x(), max.y() + width, max.z()), SplatterSection.UvModification.U_FLIP);
            }
            case Direction.NORTH -> {
                if (inside) {
                    yield section.wrapped(Direction.WEST, new Vector3f(min.x(), min.y(), min.z() - width), new Vector3f(min.x(), max.y(), max.z()), SplatterSection.UvModification.SWAP_U_FLIP);
                }
                yield section.wrapped(Direction.WEST, new Vector3f(max.x(), min.y(), min.z()), new Vector3f(max.x(), max.y(), max.z() + width), SplatterSection.UvModification.SWAP_U_FLIP);
            }
            case Direction.SOUTH -> {
                if (inside) {
                    yield section.wrapped(Direction.WEST, min, new Vector3f(min.x(), max.y(), max.z() + width), SplatterSection.UvModification.SWAP_V_FLIP);
                }
                yield section.wrapped(Direction.WEST, new Vector3f(max.x(), min.y(), min.z()), new Vector3f(max.x(), max.y(), max.z() - width), SplatterSection.UvModification.SWAP);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(section.getDirection()));
        };
    }

    private static SplatterSection wrapSouth(SplatterSection section, Vector3f min, Vector3f max, boolean inside) {
        FloatFloatPair dims = SplatterSplitter.getDims(section.getDirection(), min, max);
        float height = dims.rightFloat();
        return switch (section.getDirection()) {
            case Direction.UP -> {
                if (inside) {
                    yield section.wrapped(Direction.SOUTH, new Vector3f(min.x(), min.y(), max.z()), new Vector3f(max.x(), max.y() + height, max.z()));
                }
                yield section.wrapped(Direction.SOUTH, new Vector3f(min.x(), min.y() - height, min.z()), new Vector3f(max.x(), max.y(), min.z()));
            }
            case Direction.DOWN -> {
                if (inside) {
                    yield section.wrapped(Direction.SOUTH, new Vector3f(min.x(), min.y() - height, max.z()), max, SplatterSection.UvModification.V_FLIP);
                }
                yield section.wrapped(Direction.SOUTH, min, new Vector3f(max.x(), max.y() + height, min.z()), SplatterSection.UvModification.V_FLIP);
            }
            case Direction.WEST -> {
                if (inside) {
                    yield section.wrapped(Direction.SOUTH, new Vector3f(min.x() - height, min.y(), max.z()), max, SplatterSection.UvModification.SWAP_U_FLIP);
                }
                yield section.wrapped(Direction.SOUTH, min, new Vector3f(max.x() + height, max.y(), min.z()), SplatterSection.UvModification.SWAP_U_FLIP);
            }
            case Direction.EAST -> {
                if (inside) {
                    yield section.wrapped(Direction.SOUTH, new Vector3f(min.x(), min.y(), max.z()), new Vector3f(max.x() + height, max.y(), max.z()), SplatterSection.UvModification.SWAP_V_FLIP);
                }
                yield section.wrapped(Direction.SOUTH, new Vector3f(min.x() - height, min.y(), min.z()), new Vector3f(max.x(), max.y(), min.z()), SplatterSection.UvModification.SWAP_V_FLIP);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(section.getDirection()));
        };
    }

    private static SplatterSection wrapEast(SplatterSection section, Vector3f min, Vector3f max, boolean inside) {
        FloatFloatPair dims = SplatterSplitter.getDims(section.getDirection(), min, max);
        float width = dims.leftFloat();
        return switch (section.getDirection()) {
            case Direction.UP -> {
                if (inside) {
                    yield section.wrapped(Direction.EAST, new Vector3f(max.x(), min.y(), min.z()), new Vector3f(max.x(), max.y() + width, max.z()));
                }
                yield section.wrapped(Direction.EAST, new Vector3f(min.x(), min.y() - width, min.z()), new Vector3f(min.x(), max.y(), max.z()));
            }
            case Direction.DOWN -> {
                if (inside) {
                    yield section.wrapped(Direction.EAST, new Vector3f(max.x(), min.y() - width, min.z()), max, SplatterSection.UvModification.U_FLIP);
                }
                yield section.wrapped(Direction.EAST, min, new Vector3f(min.x(), max.y() + width, max.z()), SplatterSection.UvModification.U_FLIP);
            }
            case Direction.NORTH -> {
                if (inside) {
                    yield section.wrapped(Direction.EAST, new Vector3f(max.x(), min.y(), min.z() - width), max, SplatterSection.UvModification.SWAP_V_FLIP);
                }
                yield section.wrapped(Direction.EAST, min, new Vector3f(min.x(), max.y(), max.z() + width), SplatterSection.UvModification.SWAP_V_FLIP);
            }
            case Direction.SOUTH -> {
                if (inside) {
                    yield section.wrapped(Direction.EAST, new Vector3f(max.x(), min.y(), min.z()), new Vector3f(max.x(), max.y(), max.z() + width), SplatterSection.UvModification.SWAP_U_FLIP);
                }
                yield section.wrapped(Direction.EAST, new Vector3f(min.x(), min.y(), min.z() - width), new Vector3f(min.x(), max.y(), max.z()), SplatterSection.UvModification.SWAP_U_FLIP);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(section.getDirection()));
        };
    }

    private static List<ObjectBooleanPair<Direction>> findAnchors(Splatter splatter, SplatterSection section) {
        BlockPos anchor = section.getBlockPos().m_121945_(splatter.getDirection().m_122424_());
        if (SplatterSplitter.isValidAnchor(splatter.getWorld(), anchor) && !SplatterSplitter.isValidAnchor(splatter.getWorld(), section.getBlockPos())) {
            return null;
        }
        Pair<Direction.Axis, Direction.Axis> axes = SplatterSplitter.getAxesForDirection(section.getDirection());
        Direction.Axis a1 = (Direction.Axis)axes.first();
        Direction.Axis a2 = (Direction.Axis)axes.second();
        Vector3f sectionCenter = section.getCenter();
        double dx = (double)VecExtensions.getComponentAlongAxis(sectionCenter, a1) - splatter.getPos().m_82507_(a1);
        double dz = (double)VecExtensions.getComponentAlongAxis(sectionCenter, a2) - splatter.getPos().m_82507_(a2);
        Direction horizontal = Direction.m_122387_((Direction.Axis)a1, (Direction.AxisDirection)(dx >= 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        Direction vertical = Direction.m_122387_((Direction.Axis)a2, (Direction.AxisDirection)(dz >= 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        return Stream.of(vertical, horizontal).map(direction -> {
            if (SplatterSplitter.isValidAnchor(splatter.getWorld(), section.getBlockPos())) {
                return ObjectBooleanPair.of((Object)direction.m_122424_(), (boolean)true);
            }
            if (SplatterSplitter.isValidAnchor(splatter.getWorld(), anchor.m_121945_(direction.m_122424_()))) {
                return ObjectBooleanPair.of((Object)direction, (boolean)false);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    private static Pair<Direction.Axis, Direction.Axis> getAxesForDirection(Direction direction) {
        Direction.Axis axis = direction.m_122434_();
        Direction.Axis a1 = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Direction.Axis.Y;
            case Direction.Axis.Y, Direction.Axis.Z -> Direction.Axis.X;
        };
        Direction.Axis a2 = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.Z -> Direction.Axis.Y;
            case Direction.Axis.X, Direction.Axis.Y -> Direction.Axis.Z;
        };
        return Pair.of((Object)a1, (Object)a2);
    }

    private static FloatFloatPair getDims(Direction facing, Vector3f min, Vector3f max) {
        Pair<Direction.Axis, Direction.Axis> axes = SplatterSplitter.getAxesForDirection(facing);
        Direction.Axis a1 = (Direction.Axis)axes.first();
        Direction.Axis a2 = (Direction.Axis)axes.second();
        float width = VecExtensions.getComponentAlongAxis(max, a1) - VecExtensions.getComponentAlongAxis(min, a1);
        float height = VecExtensions.getComponentAlongAxis(max, a2) - VecExtensions.getComponentAlongAxis(min, a2);
        return FloatFloatPair.of((float)width, (float)height);
    }

    private SplatterSplitter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

