/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.tickable;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import lombok.NonNull;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.tickable.TickableHashMap;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class FrameDataRequests {
    private static final TickableHashMap<ServerPlayer, FrameData> frameDataRequests = new TickableHashMap();
    private static final Component CLICK_FOR_DEFINITION = Component.m_237115_((String)"jcraft.framedata.definition");
    private static final Style STARTUP_STYLE = Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)CLICK_FOR_DEFINITION)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://glossary.infil.net/?t=Startup"));
    private static final Style ACTIVE_STYLE = Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)CLICK_FOR_DEFINITION)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://glossary.infil.net/?t=Active"));
    private static final Style RECOVERY_STYLE = Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)CLICK_FOR_DEFINITION)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://glossary.infil.net/?t=Recovery"));

    public static void add(ServerPlayer serverPlayer, FrameDataType type) {
        frameDataRequests.add(serverPlayer, new FrameData(serverPlayer.m_9236_().m_46467_(), type));
    }

    public static void tick() {
        frameDataRequests.tick(iter -> {
            int moveStun;
            AbstractMove<?, ?> move;
            MoveSet.ReloadListener<?, ?> attacker;
            Map.Entry entry = (Map.Entry)iter.next();
            ServerPlayer player = (ServerPlayer)entry.getKey();
            FrameData frameData = (FrameData)entry.getValue();
            if (!player.m_6084_()) {
                iter.remove();
                player.m_5661_((Component)Component.m_237115_((String)"jcraft.framedata.death"), false);
                return;
            }
            boolean wasActive = false;
            if (frameData.getType() == FrameDataType.STAND) {
                StandEntity<?, ?> stand = JComponentPlatformUtils.getStandComponent((LivingEntity)player).getStand();
                attacker = stand;
                move = stand != null ? stand.getCurrentMove() : null;
            } else {
                JSpec<?, ?> spec = JComponentPlatformUtils.getSpecData((LivingEntity)player).getSpec();
                attacker = spec;
                move = spec != null && spec.moveStun > 0 ? spec.getCurrentMove() : null;
            }
            if (attacker == null) {
                return;
            }
            if (move != null) {
                wasActive = move.shouldPerform(attacker, attacker.getMoveStun());
            }
            if (frameData.lastMove != null || move != null) {
                frameData.ticks.add(new Tick(wasActive));
            }
            if ((moveStun = attacker.getMoveStun()) > 0) {
                if (frameData.lastMove != move) {
                    if (move != null) {
                        player.m_5661_((Component)Component.m_237113_((String)("New move in sequence: " + move.getName().getString())), false);
                    }
                } else if (move == null) {
                    frameData.ticks.add(new Tick(false));
                }
            } else if (frameData.lastMove != null || frameData.lastMove == null && move == null && !frameData.ticks.isEmpty()) {
                FrameDataRequests.sendFrameData(player, frameData.lastMove, frameData.ticks);
                iter.remove();
            }
            frameData.lastMove = move;
        });
    }

    private static void sendFrameData(@NonNull ServerPlayer recipient, AbstractMove<?, ?> move, @NonNull Queue<Tick> ticks) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (ticks == null) {
            throw new NullPointerException("ticks is marked non-null but is null");
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        boolean isStartup = true;
        boolean wasActive = false;
        int startup = 0;
        int recovery = 0;
        LinkedList<Integer> actives = new LinkedList<Integer>();
        while (!ticks.isEmpty()) {
            Tick tick = ticks.poll();
            boolean active = tick.active();
            if (wasActive != active) {
                actives.add(1);
            } else if (!actives.isEmpty()) {
                Integer activeCount = (Integer)actives.pollLast();
                actives.add(activeCount + 1);
            }
            if (active) {
                isStartup = false;
                recovery = 0;
            } else {
                ++recovery;
                if (first) {
                    builder.append("\u00a7b");
                }
            }
            if (isStartup) {
                ++startup;
                recovery = 0;
            }
            wasActive = active;
            builder.append(active ? "\u00a7c\u25cf\u00a7r" : "\u25cf");
            first = false;
        }
        actives.pollLast();
        String frameDataString = builder.toString();
        int recoveryFromEnd = frameDataString.length() - recovery;
        String frameDataDots = frameDataString.substring(0, recoveryFromEnd) + "\u00a7a" + frameDataString.substring(recoveryFromEnd);
        recipient.m_5661_((Component)Component.m_237113_((String)frameDataDots), false);
        StringBuilder activeFrameString = new StringBuilder();
        boolean isAttack = true;
        while (!actives.isEmpty()) {
            Integer activeCount = (Integer)actives.poll();
            activeFrameString.append(isAttack ? "\u00a7c" + activeCount + "\u00a7r" : "\u00a78" + activeCount + "\u00a7r");
            isAttack = !isAttack;
        }
        String startupName = recovery > 0 ? "Startup" : "Duration";
        MutableComponent frameDataStats = Component.m_237113_((String)(startupName + ": \u00a7b" + startup + "\u00a7r ticks\n")).m_6270_(STARTUP_STYLE);
        if (!activeFrameString.isEmpty()) {
            frameDataStats.m_7220_((Component)Component.m_237113_((String)("Active: " + String.valueOf(activeFrameString) + " ticks\n")).m_6270_(ACTIVE_STYLE));
        }
        if (recovery > 0) {
            frameDataStats.m_7220_((Component)Component.m_237113_((String)("Recovery: \u00a7a" + recovery + "\u00a7r ticks\n")).m_6270_(RECOVERY_STYLE));
        }
        if (move != null) {
            FrameDataRequests.sendMoveInfo(recipient, move, recovery);
        }
        recipient.m_5661_((Component)frameDataStats, false);
    }

    private static void sendMoveInfo(@NonNull ServerPlayer player, @NonNull AbstractMove<?, ?> move, int recovery) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (move == null) {
            throw new NullPointerException("move is marked non-null but is null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("======== Last move: \u00a72").append(move.getName().getString()).append("\u00a7r ========\n");
        stringBuilder.append("Move distance: \u00a76").append(move.getMoveDistance()).append("\u00a7r m\n");
        int armor = move.getArmor();
        if (armor > 0) {
            stringBuilder.append("\u00a7rAttack has: \u00a77").append((String)(armor == Integer.MAX_VALUE ? "Hyper Armor\u00a7r\n" : armor + " Armor Points\u00a7r\n"));
        }
        if (move instanceof AbstractSimpleAttack) {
            AbstractSimpleAttack attack = (AbstractSimpleAttack)move;
            if (attack.getBlockableType() == BlockableType.NON_BLOCKABLE_EFFECTS_ONLY) {
                stringBuilder.append("\u00a7rEffects on hit are \u00a75Unblockable\u00a7r\n");
            }
            if (attack.getHitboxSize() > 0.0f || !attack.getExtraHitBoxes().isEmpty()) {
                stringBuilder.append("Damage: \u00a76").append(attack.getDamage() / 2.0f).append("\u00a7r hearts\n").append("Knockback: \u00a76").append(attack.getKnockback()).append("\u00a7r\n");
                stringBuilder.append("Advantage on hit: \u00a7c").append(attack.getStun() - recovery - 1).append("\u00a7r ticks of ").append((Object)attack.getStunType()).append(" Stun\n");
                if (attack.getBlockableType() == BlockableType.NON_BLOCKABLE) {
                    stringBuilder.append("\u00a75Unblockable\u00a7r\n");
                } else {
                    stringBuilder.append("Advantage on block: \u00a75").append(attack.getBlockStun() - recovery).append("\u00a7r ticks");
                }
            } else {
                stringBuilder.append("No physical hit\n");
            }
        }
        player.m_5661_(Component.m_130674_((String)stringBuilder.toString()), false);
    }

    private static class FrameData {
        public final long initialTick;
        public Queue<Tick> ticks = new LinkedList<Tick>();
        public int finalAdvantage;
        public AbstractMove<?, ? super IAttacker<?, ?>> lastMove = null;
        private final FrameDataType type;

        FrameData(long initialTick, FrameDataType type) {
            this.initialTick = initialTick;
            this.type = type;
        }

        public FrameDataType getType() {
            return this.type;
        }
    }

    public static enum FrameDataType {
        STAND,
        SPEC;

    }

    private record Tick(boolean active) {
    }
}

